/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.hadoop.sequencefile;

import com.google.common.io.Closeables;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class ReadSequenceFileBuilder
implements CommandBuilder {
    public static final String OUTPUT_MEDIA_TYPE = "application/java-sequence-file-record";
    public static final String SEQUENCE_FILE_META_DATA = "sequenceFileMetaData";
    public static final String CONFIG_KEY_FIELD = "keyField";
    public static final String CONFIG_VALUE_FIELD = "valueField";

    public Collection<String> getNames() {
        return Collections.singletonList("readSequenceFile");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadSequenceFile(this, config, parent, child, context);
    }

    private static final class ForwardOnlySeekableInputStream {
        private final InputStream in;
        private long pos = 0L;

        public ForwardOnlySeekableInputStream(InputStream in) {
            this.in = in;
        }

        public long tell() throws IOException {
            return this.pos;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        }

        public long length() throws IOException {
            throw new UnsupportedOperationException("Random access is not supported");
        }

        public void seek(long p) throws IOException {
            long todo = p - this.pos;
            if (todo < 0L) {
                throw new UnsupportedOperationException("Seeking backwards is not supported");
            }
            this.skip(todo);
        }

        private long skip(long len) throws IOException {
            long todo = len = Math.max(0L, len);
            while (todo > 0L) {
                long ret = this.in.skip(todo);
                if (ret == 0L) {
                    int b = this.in.read();
                    if (b == -1) {
                        throw new EOFException("Premature EOF from inputStream after skipping " + (len - todo) + " byte(s).");
                    }
                    ret = 1L;
                }
                todo -= ret;
                this.pos += ret;
            }
            return len;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class ForwardOnlySeekable
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private ForwardOnlySeekableInputStream fosInputStream;

        public ForwardOnlySeekable(InputStream inputStream) {
            this.fosInputStream = new ForwardOnlySeekableInputStream(inputStream);
        }

        public void seek(long pos) throws IOException {
            this.fosInputStream.seek(pos);
        }

        public long getPos() throws IOException {
            return this.fosInputStream.tell();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            throw new UnsupportedOperationException("not implemented!");
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException("not implemented!");
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException("not implemented!");
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            throw new UnsupportedOperationException("not implemented!");
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int len = this.fosInputStream.read(b, 0, 1);
            int ret = len == -1 ? -1 : b[0] & 0xFF;
            return ret;
        }
    }

    private static final class ReadSequenceFile
    extends AbstractParser {
        private final boolean includeMetaData;
        private final String keyField;
        private final String valueField;
        private final Configuration conf = new Configuration();

        public ReadSequenceFile(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.includeMetaData = this.getConfigs().getBoolean(config, "includeMetaData", false);
            this.keyField = this.getConfigs().getString(config, ReadSequenceFileBuilder.CONFIG_KEY_FIELD, "_attachment_name");
            this.valueField = this.getConfigs().getString(config, ReadSequenceFileBuilder.CONFIG_VALUE_FIELD, "_attachment_body");
            this.validateArguments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean doProcess(Record inputRecord, final InputStream in) throws IOException {
            SequenceFile.Reader reader;
            block9: {
                boolean bl;
                SequenceFile.Metadata sequenceFileMetaData = null;
                reader = null;
                try {
                    Record outputRecord;
                    reader = new SequenceFile.Reader((FileSystem)FileSystem.getLocal((Configuration)this.conf), new Path("/"), this.conf){

                        protected FSDataInputStream openFile(FileSystem fs, Path f, int sz, long l) throws IOException {
                            return new FSDataInputStream((InputStream)new ForwardOnlySeekable(in));
                        }
                    };
                    if (this.includeMetaData) {
                        sequenceFileMetaData = reader.getMetadata();
                    }
                    Class keyClass = reader.getKeyClass();
                    Class valueClass = reader.getValueClass();
                    Record template = inputRecord.copy();
                    ReadSequenceFile.removeAttachments((Record)template);
                    do {
                        Writable val;
                        Writable key;
                        block8: {
                            key = (Writable)ReflectionUtils.newInstance((Class)keyClass, (Configuration)this.conf);
                            val = (Writable)ReflectionUtils.newInstance((Class)valueClass, (Configuration)this.conf);
                            try {
                                if (!reader.next(key, val)) {
                                }
                                break block8;
                            }
                            catch (EOFException ex) {
                                this.LOG.trace("Received expected EOFException", (Throwable)ex);
                            }
                            break block9;
                        }
                        this.incrementNumRecords();
                        outputRecord = template.copy();
                        outputRecord.put(this.keyField, (Object)key);
                        outputRecord.put(this.valueField, (Object)val);
                        outputRecord.put("_attachment_mimetype", (Object)ReadSequenceFileBuilder.OUTPUT_MEDIA_TYPE);
                        if (!this.includeMetaData || sequenceFileMetaData == null) continue;
                        outputRecord.put(ReadSequenceFileBuilder.SEQUENCE_FILE_META_DATA, (Object)sequenceFileMetaData);
                    } while (this.getChild().process(outputRecord));
                    bl = false;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(reader);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)reader);
                return bl;
            }
            Closeables.closeQuietly((Closeable)reader);
            return true;
        }
    }
}

