/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.sink.Sink;

public class WikiWordBlock
implements Block {
    private final String wikiword;
    private final String showText;

    public WikiWordBlock(String wikiword) {
        this(wikiword, wikiword);
    }

    public WikiWordBlock(String wikiword, String showText) throws IllegalArgumentException {
        if (wikiword == null || showText == null) {
            throw new IllegalArgumentException("arguments can't be null");
        }
        this.wikiword = wikiword;
        this.showText = showText;
    }

    public final void traverse(Sink sink) {
        sink.link("./" + this.wikiword + ".html");
        sink.text(this.showText);
        sink.link_();
    }

    public final boolean equals(Object obj) {
        boolean ret = false;
        if (obj == this) {
            ret = true;
        } else if (obj instanceof WikiWordBlock) {
            WikiWordBlock w = (WikiWordBlock)obj;
            ret = this.wikiword.equals(w.wikiword) && this.showText.equals(w.showText);
        }
        return ret;
    }

    public final int hashCode() {
        int magic1 = 17;
        int magic2 = 37;
        return 17 + 37 * this.wikiword.hashCode() + 37 * this.showText.hashCode();
    }
}

