/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.module.twiki.TWikiParser;
import org.apache.maven.doxia.module.twiki.parser.AnchorBlock;
import org.apache.maven.doxia.module.twiki.parser.LinkBlock;
import org.apache.maven.doxia.module.twiki.parser.MacroBlock;
import org.apache.maven.doxia.module.twiki.parser.State;
import org.apache.maven.doxia.module.twiki.parser.TagBlock;
import org.apache.maven.doxia.module.twiki.parser.TextBlock;
import org.apache.maven.doxia.module.twiki.parser.WikiWordBlock;

public class TextParser {
    private static final Pattern WIKIWORD_PATTERN = Pattern.compile("(!?([A-Z]\\w*[.])?([A-Z][a-z]+){2,}(#\\w*)?)");
    private static final Pattern SPECIFICLINK_PATTERN = Pattern.compile("!?\\[\\[([^\\]\\[]+)\\]\\[([^\\]\\[]+)\\]\\]");
    private static final Pattern FORCEDLINK_PATTERN = Pattern.compile("(!)?(\\[\\[([^\\]]+)\\]\\])");
    private static final Pattern ANCHOR_PATTERN = Pattern.compile("#(([A-Z][A-Za-z]*){2,})");
    private static final Pattern URL_PATTERN = Pattern.compile("(\\w+):[/][/][^\\s]*");
    private static final Pattern MACRO_PATTERN = Pattern.compile("(%)[A-Z]+[ ]*(\\{[ ]*(\"[a-zA-Z0-9]+\")?[ ]*(([a-zA-Z0-9]+[ ]*(=)[ ]*(\"[a-zA-Z0-9]+\")[ ]*)*)?\\})?(%)");
    private static final Pattern TAG_PATTERN = Pattern.compile("(<)[^>]+(>)");
    private static final Pattern TAG_END_PATTERN = Pattern.compile("(<)(/)[^>]+(>)");
    private static final Pattern PARTIAL_TAG_PATTERN = Pattern.compile("(<)(.+)");
    private static final Pattern PARTIAL_TAG_END_PATTERN = Pattern.compile("(.+)(>)");
    private static final Pattern VERBATIM_END_PATTERN = Pattern.compile("(</verbatim>)");
    private static final Pattern BLOCKQUOTE_END_PATTERN = Pattern.compile("(</blockquote>)");
    private String sourceContent;
    private TWikiParser parent;
    private boolean isWithinMacro;

    public final List parse(String line) {
        ArrayList<TextBlock> ret = new ArrayList<TextBlock>();
        Matcher linkMatcher = SPECIFICLINK_PATTERN.matcher(line);
        Matcher wikiMatcher = WIKIWORD_PATTERN.matcher(line);
        Matcher forcedLinkMatcher = FORCEDLINK_PATTERN.matcher(line);
        Matcher anchorMatcher = ANCHOR_PATTERN.matcher(line);
        Matcher urlMatcher = URL_PATTERN.matcher(line);
        Matcher macroMatcher = MACRO_PATTERN.matcher(line);
        Matcher tagMatcher = TAG_PATTERN.matcher(line);
        Matcher tagEndMatcher = TAG_END_PATTERN.matcher(line);
        Matcher partialTagMatcher = PARTIAL_TAG_PATTERN.matcher(line);
        Matcher partialTagEndMatcher = PARTIAL_TAG_END_PATTERN.matcher(line);
        Matcher verbatimEndMatcher = VERBATIM_END_PATTERN.matcher(line);
        Matcher blockquoteEndMatcher = BLOCKQUOTE_END_PATTERN.matcher(line);
        if (State.isVerbatimMode()) {
            if (macroMatcher.find()) {
                this.parseMacro(line, ret, macroMatcher);
            } else if (verbatimEndMatcher.find()) {
                this.parseTag(line, ret, verbatimEndMatcher);
            } else if (blockquoteEndMatcher.find()) {
                this.parseTag(line, ret, blockquoteEndMatcher);
            } else if (line.length() != 0) {
                ret.add(new TextBlock(line));
            }
        } else if (macroMatcher.find()) {
            this.parseMacro(line, ret, macroMatcher);
        } else if (tagMatcher.find()) {
            this.parseTag(line, ret, tagMatcher);
        } else if (tagEndMatcher.find()) {
            this.parseTag(line, ret, tagEndMatcher);
        } else if (partialTagMatcher.find() && this.isWithinMacro) {
            this.parsePartialTag(line, ret, partialTagMatcher);
        } else if (partialTagEndMatcher.find() && this.isWithinMacro) {
            this.parsePartialTag(line, ret, partialTagEndMatcher);
        } else if (linkMatcher.find()) {
            this.parseLink(line, ret, linkMatcher);
        } else if (wikiMatcher.find() && this.startLikeWord(wikiMatcher, line) && State.isAutoLinkEnabled()) {
            this.parseWiki(line, ret, wikiMatcher);
        } else if (forcedLinkMatcher.find()) {
            this.parseForcedLink(line, ret, forcedLinkMatcher);
        } else if (anchorMatcher.find() && this.isAWord(anchorMatcher, line)) {
            this.parseAnchor(line, ret, anchorMatcher);
        } else if (urlMatcher.find() && this.isAWord(urlMatcher, line)) {
            this.parseUrl(line, ret, urlMatcher);
        } else if (line.length() != 0) {
            ret.add(new TextBlock(line));
        }
        return ret;
    }

    private void parseTag(String line, List ret, Matcher tagMatcher) {
        ret.addAll(this.parse(line.substring(0, tagMatcher.start())));
        String tagStr = tagMatcher.group(0);
        String tag = tagStr.substring(1, tagStr.length() - 1);
        ret.add(new TagBlock(tag, false));
        ret.addAll(this.parse(line.substring(tagMatcher.end(), line.length())));
    }

    private void parsePartialTag(String line, List ret, Matcher tagMatcher) {
        ret.addAll(this.parse(line.substring(0, tagMatcher.start())));
        String tag = tagMatcher.group(0);
        ret.add(new TagBlock(tag, true));
        ret.addAll(this.parse(line.substring(tagMatcher.end(), line.length())));
    }

    private void parseMacro(String line, List ret, Matcher macroMatcher) {
        this.isWithinMacro = true;
        ret.addAll(this.parse(line.substring(0, macroMatcher.start())));
        String macro = macroMatcher.group(0);
        String macroName = macro.substring(1, macro.length() - 1);
        String restLine = line.substring(macroMatcher.end(), line.length());
        ret.add(new MacroBlock(macroName, this.sourceContent, this.parent, restLine));
        ret.addAll(this.parse(restLine));
        this.isWithinMacro = false;
    }

    private void parseUrl(String line, List ret, Matcher urlMatcher) {
        ret.addAll(this.parse(line.substring(0, urlMatcher.start())));
        String url = urlMatcher.group(0);
        ret.add(new LinkBlock(url, url));
        ret.addAll(this.parse(line.substring(urlMatcher.end(), line.length())));
    }

    private void parseAnchor(String line, List ret, Matcher anchorMatcher) {
        ret.addAll(this.parse(line.substring(0, anchorMatcher.start())));
        ret.add(new AnchorBlock(anchorMatcher.group(1)));
        ret.addAll(this.parse(line.substring(anchorMatcher.end(), line.length())));
    }

    private void parseForcedLink(String line, List ret, Matcher forcedLinkMatcher) {
        if (forcedLinkMatcher.group(1) != null) {
            ret.add(new TextBlock(forcedLinkMatcher.group(2)));
        } else {
            String showText = forcedLinkMatcher.group(3);
            if (showText.trim().startsWith("mailto:")) {
                String s = showText.trim();
                int i = s.indexOf(32);
                if (i == -1) {
                    ret.add(new TextBlock(s));
                } else {
                    ret.add(new LinkBlock(s.substring(0, i), s.substring(i).trim()));
                }
            } else {
                StringTokenizer tokenizer = new StringTokenizer(showText);
                StringBuffer sb = new StringBuffer();
                while (tokenizer.hasMoreElements()) {
                    String s = tokenizer.nextToken();
                    sb.append(s.substring(0, 1).toUpperCase());
                    sb.append(s.substring(1));
                }
                ret.addAll(this.parse(line.substring(0, forcedLinkMatcher.start())));
                ret.add(new WikiWordBlock(sb.toString(), showText));
                ret.addAll(this.parse(line.substring(forcedLinkMatcher.end(), line.length())));
            }
        }
    }

    private void parseWiki(String line, List ret, Matcher wikiMatcher) {
        String wikiWord = wikiMatcher.group();
        ret.addAll(this.parse(line.substring(0, wikiMatcher.start())));
        if (wikiWord.startsWith("!")) {
            ret.add(new TextBlock(wikiWord.substring(1)));
        } else {
            ret.add(new WikiWordBlock(wikiWord));
        }
        ret.addAll(this.parse(line.substring(wikiMatcher.end(), line.length())));
    }

    private void parseLink(String line, List ret, Matcher linkMatcher) {
        ret.addAll(this.parse(line.substring(0, linkMatcher.start())));
        if (line.charAt(linkMatcher.start()) == '!') {
            ret.add(new TextBlock(line.substring(linkMatcher.start() + 1, linkMatcher.end())));
        } else {
            ret.add(new LinkBlock(linkMatcher.group(1), linkMatcher.group(2)));
        }
        ret.addAll(this.parse(line.substring(linkMatcher.end(), line.length())));
    }

    private boolean isAWord(Matcher m, String line) {
        return this.startLikeWord(m, line) && this.endLikeWord(m, line);
    }

    private boolean startLikeWord(Matcher m, String line) {
        int start = m.start();
        boolean ret = false;
        if (start == 0) {
            ret = true;
        } else if (start > 0 && this.isSpace(line.charAt(start - 1))) {
            ret = true;
        }
        return ret;
    }

    private boolean endLikeWord(Matcher m, String line) {
        int end = m.end();
        boolean ret = true;
        if (end < line.length()) {
            ret = this.isSpace(line.charAt(end));
        }
        return ret;
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    public void setSourceContent(String sourceContent) {
        this.sourceContent = sourceContent;
    }

    public void setParent(TWikiParser parser) {
        this.parent = parser;
    }
}

