/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.State;
import org.apache.maven.doxia.sink.Sink;

public class TagBlock
implements Block {
    public int tag;
    public String html;
    private boolean isEndTag;
    private static final String BLOCKQUOTE_NAME = "BLOCKQUOTE";
    private static final String NOAUTOLINK_NAME = "NOAUTOLINK";
    private static final String VERBATIM_NAME = "VERBATIM";
    private static final String CODE_NAME = "CODE";
    private static final int BLOCKQUOTE = 1;
    private static final int HTML = 2;
    private static final int VERBATIM = 3;
    private static final int CODE = 4;
    private static final int PARTIAL_HTML = 5;
    private static final int NO_AUTOLINK = 6;

    public TagBlock(String tag, boolean isPartial) throws IllegalArgumentException {
        String tagName;
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null");
        }
        if (tag.startsWith("/")) {
            this.isEndTag = true;
            tagName = tag.substring(1);
        } else {
            tagName = tag;
        }
        if (tagName.equalsIgnoreCase(BLOCKQUOTE_NAME)) {
            this.tag = 1;
            if (this.isEndTag) {
                State.clearVerbatimMode();
            } else {
                State.setVerbatimMode();
            }
        } else if (tagName.equalsIgnoreCase(VERBATIM_NAME)) {
            this.tag = 3;
            if (this.isEndTag) {
                State.clearVerbatimMode();
            } else {
                State.setVerbatimMode();
            }
        } else if (tagName.equalsIgnoreCase(NOAUTOLINK_NAME)) {
            this.tag = 6;
            if (this.isEndTag) {
                State.enableAutoLinking();
            } else {
                State.disableAutoLinking();
            }
        } else if (tagName.equalsIgnoreCase(CODE_NAME)) {
            this.tag = 4;
        } else {
            this.tag = isPartial ? 5 : 2;
            this.html = tag;
        }
    }

    public final void traverse(Sink sink) {
        if (this.isEndTag) {
            switch (this.tag) {
                case 1: {
                    sink.verbatim_();
                    break;
                }
                case 3: {
                    sink.rawText("</pre>");
                    break;
                }
                case 4: {
                    sink.monospaced_();
                    break;
                }
                case 2: {
                    sink.rawText("<" + this.html + ">");
                    break;
                }
                case 5: {
                    sink.rawText(this.html);
                }
            }
        } else {
            switch (this.tag) {
                case 1: {
                    sink.verbatim(false);
                    break;
                }
                case 3: {
                    sink.rawText("<pre>");
                    break;
                }
                case 4: {
                    sink.monospaced();
                    break;
                }
                case 2: {
                    sink.rawText("<" + this.html + ">");
                    break;
                }
                case 5: {
                    sink.rawText(this.html);
                }
            }
        }
    }

    public final boolean equals(Object obj) {
        boolean ret = false;
        if (obj == this) {
            ret = true;
        } else if (obj instanceof TagBlock) {
            TagBlock l = (TagBlock)obj;
            ret = this.tag == l.tag;
        }
        return ret;
    }

    public final int hashCode() {
        int magic1 = 17;
        int magic2 = 37;
        return 17 + 37 * this.tag;
    }
}

