/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import org.apache.maven.doxia.util.ByLineSource;

public class StringLineSource
implements ByLineSource {
    private String source;
    private int nextLineBreakIndex;
    private int lastLineBreakIndex;
    private int lineNumber;

    public StringLineSource(String source) {
        this.source = source;
        this.lastLineBreakIndex = -1;
        this.nextLineBreakIndex = source.indexOf("\n");
        this.lineNumber = 1;
    }

    public String getNextLine() {
        String line = null;
        if (this.nextLineBreakIndex >= 0) {
            line = this.source.substring(this.lastLineBreakIndex + 1, this.nextLineBreakIndex);
            this.lastLineBreakIndex = this.nextLineBreakIndex;
            this.nextLineBreakIndex = this.source.indexOf("\n", this.nextLineBreakIndex + 1);
            ++this.lineNumber;
        }
        return line;
    }

    public String getName() {
        return "";
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void ungetLine() {
        if (this.nextLineBreakIndex > 0) {
            this.nextLineBreakIndex = this.lastLineBreakIndex;
        }
        this.lastLineBreakIndex = this.source.substring(0, this.lastLineBreakIndex).lastIndexOf("\n");
    }

    public void unget(String s) throws IllegalStateException {
        if (s == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        if (s.length() != 0) {
            this.ungetLine();
            int newNext = this.source.substring(0, this.nextLineBreakIndex).lastIndexOf(s);
            if (newNext > 0) {
                this.nextLineBreakIndex = newNext;
            }
        }
    }

    public void close() {
    }
}

