/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Stack;
import org.apache.maven.doxia.index.IndexingSink;
import org.apache.maven.doxia.module.twiki.parser.AbstractFatherBlock;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.State;
import org.apache.maven.doxia.sink.Sink;

public class SectionBlock
extends AbstractFatherBlock {
    private final String title;
    private final String rawTitle;
    private final int level;
    private static Stack levelStack = new Stack();

    public SectionBlock(String title, int level, Block[] blocks) throws IllegalArgumentException {
        super(blocks);
        int maxLevel = 5;
        if (title == null) {
            throw new IllegalArgumentException("title cant be null");
        }
        if (level < 1 || level > 5) {
            throw new IllegalArgumentException("invalid level: " + level);
        }
        this.title = title.trim().startsWith("!!") ? title.trim().substring(2) : title.trim();
        this.rawTitle = title;
        this.level = level;
    }

    public final void before(Sink sink) {
        String titleAnchor = this.title;
        while (State.isInTitleList(sink, titleAnchor)) {
            titleAnchor = titleAnchor + "_";
        }
        State.addToTitleList(sink, titleAnchor);
        sink.anchor(SectionBlock.encodeId(titleAnchor));
        sink.anchor_();
        this.sectionStart(sink);
        this.sectionTitle(sink);
        if (sink instanceof IndexingSink) {
            sink.text(this.rawTitle);
        } else {
            sink.text(this.title);
        }
        this.sectionTitle_(sink);
    }

    public final void after(Sink sink) {
        this.sectionEnd(sink);
    }

    private void sectionStart(Sink sink) {
        while (!levelStack.isEmpty() && this.level <= (Integer)levelStack.peek()) {
            int outLevel = (Integer)levelStack.pop();
            SectionBlock.invokeVoidVoid(sink, "section" + outLevel + "_");
        }
        levelStack.push(new Integer(this.level));
        SectionBlock.invokeVoidVoid(sink, "section" + this.level);
    }

    private void sectionEnd(Sink sink) {
    }

    private static void invokeVoidVoid(Sink sink, String name) throws IllegalArgumentException {
        try {
            Method m = sink.getClass().getMethod(name, new Class[0]);
            m.invoke((Object)sink, Collections.EMPTY_LIST.toArray());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invoking sink's " + name + " method: " + e.getMessage());
        }
    }

    public final int getLevel() {
        return this.level;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Section  {title: '");
        sb.append(this.getTitle());
        sb.append("' level: ");
        sb.append(this.getLevel());
        sb.append("}: [");
        for (int i = 0; i < this.getBlocks().length; ++i) {
            Block block = this.getBlocks()[i];
            sb.append(block.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void sectionTitle(Sink sink) {
        SectionBlock.invokeVoidVoid(sink, "sectionTitle" + this.level);
    }

    private void sectionTitle_(Sink sink) {
        SectionBlock.invokeVoidVoid(sink, "sectionTitle" + this.level + "_");
    }

    public static void clearLevelStack() {
        while (!levelStack.isEmpty()) {
            levelStack.pop();
        }
    }

    public static void closeAllSections(Sink sink) {
        while (!levelStack.isEmpty()) {
            int outLevel = (Integer)levelStack.pop();
            SectionBlock.invokeVoidVoid(sink, "section" + outLevel + "_");
        }
    }

    public static String encodeId(String id) {
        if (id == null) {
            return null;
        }
        id = id.trim();
        int length = id.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                buffer.append("a");
            }
            if (c == ' ') {
                buffer.append("_");
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != ':' && c != '.') continue;
            buffer.append(c);
        }
        return buffer.toString();
    }
}

