/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.BlockParser;
import org.apache.maven.doxia.module.twiki.parser.FormatedTextParser;
import org.apache.maven.doxia.module.twiki.parser.GenericListBlockParser;
import org.apache.maven.doxia.module.twiki.parser.HRuleBlockParser;
import org.apache.maven.doxia.module.twiki.parser.NopBlock;
import org.apache.maven.doxia.module.twiki.parser.ParagraphBlock;
import org.apache.maven.doxia.module.twiki.parser.SectionBlockParser;
import org.apache.maven.doxia.module.twiki.parser.State;
import org.apache.maven.doxia.module.twiki.parser.TableBlockParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class ParagraphBlockParser
implements BlockParser {
    private final Pattern paragraphSeparator = Pattern.compile("^(\\s*)$");
    private SectionBlockParser sectionParser;
    private GenericListBlockParser listParser;
    private FormatedTextParser textParser;
    private HRuleBlockParser hrulerParser;
    private TableBlockParser tableBlockParser;
    private static final NopBlock NOP = new NopBlock();

    public final boolean accept(String line) {
        return State.isVerbatimMode() || !this.sectionParser.accept(line) && !this.hrulerParser.accept(line);
    }

    public final List getBlocklist(String line, ByLineSource source, List childs) throws ParseException {
        StringBuffer sb = new StringBuffer();
        if (childs == null) {
            childs = new ArrayList<Block>();
        }
        boolean sawText = false;
        String l = line;
        do {
            Matcher m;
            if ((m = this.paragraphSeparator.matcher(l)).lookingAt()) {
                if (sawText) break;
                continue;
            }
            sawText = true;
            if (this.listParser.accept(l)) {
                if (sb.length() != 0) {
                    childs.addAll(Arrays.asList(this.textParser.parse(sb.toString().trim())));
                    sb = new StringBuffer();
                }
                childs.add(this.listParser.visit(l, source));
                continue;
            }
            if (this.tableBlockParser.accept(l) && !State.isVerbatimMode()) {
                childs.add(this.tableBlockParser.visit(l, source));
                continue;
            }
            sb.append(l);
            sb.append("\n");
        } while ((l = source.getNextLine()) != null && this.accept(l));
        if (line != null) {
            source.ungetLine();
        }
        if (sb.length() != 0) {
            if (State.isVerbatimMode()) {
                childs.addAll(Arrays.asList(this.textParser.parse(sb.toString())));
            } else {
                childs.addAll(Arrays.asList(this.textParser.parse(sb.toString().trim())));
            }
            sb = new StringBuffer();
        }
        if (State.isVerbatimMode()) {
            return this.getBlocklist(l, source, childs);
        }
        return childs;
    }

    public final Block visit(String line, ByLineSource source) throws ParseException {
        List childs = this.getBlocklist(line, source, null);
        if (childs.size() == 0) {
            return NOP;
        }
        return new ParagraphBlock(childs.toArray(new Block[0]));
    }

    public final void setSectionParser(SectionBlockParser sectionParser) {
        if (sectionParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.sectionParser = sectionParser;
    }

    public final void setListParser(GenericListBlockParser listParser) {
        if (listParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.listParser = listParser;
    }

    public final void setTextParser(FormatedTextParser textParser) {
        if (textParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.textParser = textParser;
    }

    public final void setHrulerParser(HRuleBlockParser hrulerParser) {
        if (hrulerParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.hrulerParser = hrulerParser;
    }

    public final void setTableBlockParser(TableBlockParser tableBlockParser) {
        if (tableBlockParser == null) {
            throw new IllegalArgumentException("arg can't be null");
        }
        this.tableBlockParser = tableBlockParser;
    }
}

