/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.module.twiki.TWikiParser;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.State;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public class MacroBlock
implements Block {
    public final String macro;
    public final String lineAfterMacro;
    private String sourceContent;
    private TWikiParser parser;

    public MacroBlock(String macroDef, String sourceContent, TWikiParser parser, String restLine) throws IllegalArgumentException {
        if (macroDef == null) {
            throw new IllegalArgumentException("macro cannot be null");
        }
        this.macro = macroDef;
        if (this.macro.startsWith("CODE")) {
            State.setVerbatimMode();
        }
        if (this.macro.startsWith("ENDCODE")) {
            State.clearVerbatimMode();
        }
        this.parser = parser;
        this.sourceContent = sourceContent;
        this.lineAfterMacro = restLine;
    }

    public final void traverse(Sink sink) {
        if (this.parser.isSecondParsing()) {
            return;
        }
        String s = this.macro;
        s = this.escapeForMacro(s);
        String[] params = StringUtils.split((String)s, (String)"{");
        String macroId = params[0].toLowerCase();
        Map<String, String> parameters = new HashMap<String, String>();
        if (params.length > 1) {
            parameters = this.getParams(params[1]);
        }
        parameters.put("sourceContent", this.sourceContent);
        TWikiParser twikiParser = new TWikiParser();
        twikiParser.setSecondParsing(true);
        parameters.put("parser", (String)((Object)twikiParser));
        parameters.put("afterMacroLine", this.lineAfterMacro);
        MacroRequest request = new MacroRequest(parameters, this.getBasedir());
        try {
            this.parser.executeMacro(macroId, request, sink);
        }
        catch (MacroExecutionException e) {
            throw new IllegalArgumentException("Unable to execute macro in the Twiki document", e);
        }
        catch (MacroNotFoundException e) {
            throw new IllegalArgumentException("Unable to find macro used in the Twiki document", e);
        }
    }

    private Map getParams(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        String paramList = s.trim();
        if (paramList.length() > 0) {
            if (!paramList.endsWith("}")) {
                throw new IllegalArgumentException("No ending } for macro: " + s);
            }
            int beginIndex = paramList.indexOf("\"") + 1;
            int endIndex = -1;
            if (beginIndex == 1) {
                endIndex = paramList.indexOf("\"", beginIndex);
                String value = paramList.substring(beginIndex, endIndex);
                map.put("default", value);
                beginIndex = paramList.indexOf("\"", endIndex + 1) + 1;
            }
            while (beginIndex > 0 && endIndex < paramList.length() - 1) {
                int beginEquals = paramList.indexOf("=", endIndex);
                String param = paramList.substring(endIndex + 1, beginEquals).trim();
                endIndex = paramList.indexOf("\"", beginIndex);
                String value = paramList.substring(beginIndex, endIndex);
                map.put(param, value);
                beginIndex = paramList.indexOf("\"", endIndex + 1) + 1;
            }
        }
        return map;
    }

    public final boolean equals(Object obj) {
        boolean ret = false;
        if (obj == this) {
            ret = true;
        } else if (obj instanceof MacroBlock) {
            MacroBlock l = (MacroBlock)obj;
            ret = this.macro.equals(l.macro);
        }
        return ret;
    }

    public final int hashCode() {
        int magic1 = 17;
        int magic2 = 37;
        return 17 + 37 * this.macro.hashCode();
    }

    private String escapeForMacro(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        String result = s;
        result = StringUtils.replace((String)result, (String)"\\=", (String)"\u0011");
        result = StringUtils.replace((String)result, (String)"\\|", (String)"\u0012");
        return result;
    }

    private String unescapeForMacro(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        String result = s;
        result = StringUtils.replace((String)result, (String)"\u0011", (String)"=");
        result = StringUtils.replace((String)result, (String)"\u0012", (String)"|");
        return result;
    }

    protected File getBasedir() {
        String basedir = System.getProperty("basedir");
        if (basedir != null) {
            return new File(basedir);
        }
        return new File(new File("").getAbsolutePath());
    }
}

