/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.sink.Sink;

public class LinkBlock
implements Block {
    private final String reference;
    private final String text;

    public LinkBlock(String reference, String text) throws IllegalArgumentException {
        if (reference == null || text == null) {
            throw new IllegalArgumentException("arguments can't be null");
        }
        this.reference = reference;
        this.text = text;
    }

    public final void traverse(Sink sink) {
        int indexOfHash;
        String referenceValue = this.isExternalLink(this.reference) ? this.reference : ((indexOfHash = this.reference.indexOf("#")) > 0 ? "./" + this.reference.substring(0, indexOfHash) + ".html" + this.reference.substring(indexOfHash) : "./" + this.reference + ".html");
        sink.link(referenceValue);
        sink.text(this.text);
        sink.link_();
    }

    public final boolean equals(Object obj) {
        boolean ret = false;
        if (obj == this) {
            ret = true;
        } else if (obj instanceof LinkBlock) {
            LinkBlock l = (LinkBlock)obj;
            ret = this.reference.equals(l.reference) && this.text.equals(l.text);
        }
        return ret;
    }

    public final int hashCode() {
        int magic1 = 17;
        int magic2 = 37;
        return 17 + 37 * this.reference.hashCode() + 37 * this.text.hashCode();
    }

    private boolean isExternalLink(String link) {
        String text = link.toLowerCase();
        return text.indexOf("http:/") == 0 || text.indexOf("https:/") == 0 || text.indexOf("ftp:/") == 0 || text.indexOf("mailto:") == 0 || text.indexOf("file:/") == 0 || text.indexOf("../") == 0 || text.indexOf("./") == 0;
    }
}

