/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.BlockParser;
import org.apache.maven.doxia.module.twiki.parser.FormatedTextParser;
import org.apache.maven.doxia.module.twiki.parser.ListBlock;
import org.apache.maven.doxia.module.twiki.parser.ListItemBlock;
import org.apache.maven.doxia.module.twiki.parser.NumeratedListBlock;
import org.apache.maven.doxia.module.twiki.parser.TreeListBuilder;
import org.apache.maven.doxia.module.twiki.parser.UnorderedListBlock;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class GenericListBlockParser
implements BlockParser {
    static final String EOL;
    private FormatedTextParser formatedTextParser;
    private final Pattern[] patterns = new Pattern[TYPES.length];
    private static final Type LIST;
    private static final Type ORDERED_LOWER_ALPHA;
    private static final Type ORDERED_UPPER_ALPHA;
    private static final Type ORDERERED_DECIMAL;
    private static final Type ORDERERED_LOWER_ROMAN;
    private static final Type ORDERERED_UPPER_ROMAN;
    private static final Type[] TYPES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GenericListBlockParser() {
        for (int i = 0; i < TYPES.length; ++i) {
            this.patterns[i] = Pattern.compile("^((   )+)" + TYPES[i].getItemPattern() + "(.*)$");
        }
    }

    public final boolean accept(String line) {
        boolean ret = false;
        for (int i = 0; !ret && i < this.patterns.length; ret |= this.patterns[i].matcher(line).lookingAt(), ++i) {
        }
        return ret;
    }

    public final Block visit(String line, ByLineSource source) throws ParseException {
        TreeListBuilder treeListBuilder = new TreeListBuilder(this.formatedTextParser);
        String l = line;
        while (this.accept(l)) {
            for (int i = 0; i < this.patterns.length; ++i) {
                Matcher m = this.patterns[i].matcher(l);
                if (!m.lookingAt()) continue;
                int numberOfSpaces = 3;
                int textGroup = 3;
                if (!$assertionsDisabled && m.group(1).length() % 3 != 0) {
                    throw new AssertionError();
                }
                int level = m.group(1).length() / 3;
                treeListBuilder.feedEntry(TYPES[i], level, m.group(3).trim());
                break;
            }
            if ((l = source.getNextLine()) != null) continue;
        }
        if (l != null) {
            source.ungetLine();
        }
        return treeListBuilder.getBlock();
    }

    public final void setTextParser(FormatedTextParser textParser) {
        if (textParser == null) {
            throw new IllegalArgumentException("formatTextParser can't be null");
        }
        this.formatedTextParser = textParser;
    }

    static {
        $assertionsDisabled = !GenericListBlockParser.class.desiredAssertionStatus();
        EOL = System.getProperty("line.separator");
        LIST = new Type(){

            public String getItemPattern() {
                return "[*]";
            }

            public ListBlock createList(ListItemBlock[] items) {
                return new UnorderedListBlock(items);
            }
        };
        ORDERED_LOWER_ALPHA = new Type(){

            public String getItemPattern() {
                return "[a-hj-z][.]";
            }

            public ListBlock createList(ListItemBlock[] items) {
                return new NumeratedListBlock(1, items);
            }
        };
        ORDERED_UPPER_ALPHA = new Type(){

            public String getItemPattern() {
                return "[A-HJ-Z][.]";
            }

            public ListBlock createList(ListItemBlock[] items) {
                return new NumeratedListBlock(2, items);
            }
        };
        ORDERERED_DECIMAL = new Type(){

            public String getItemPattern() {
                return "[0123456789][.]";
            }

            public ListBlock createList(ListItemBlock[] items) {
                return new NumeratedListBlock(0, items);
            }
        };
        ORDERERED_LOWER_ROMAN = new Type(){

            public String getItemPattern() {
                return "[i][.]";
            }

            public ListBlock createList(ListItemBlock[] items) {
                return new NumeratedListBlock(3, items);
            }
        };
        ORDERERED_UPPER_ROMAN = new Type(){

            public String getItemPattern() {
                return "[I][.]";
            }

            public ListBlock createList(ListItemBlock[] items) {
                return new NumeratedListBlock(4, items);
            }
        };
        TYPES = new Type[]{LIST, ORDERED_LOWER_ALPHA, ORDERED_UPPER_ALPHA, ORDERERED_DECIMAL, ORDERERED_LOWER_ROMAN, ORDERERED_UPPER_ROMAN};
    }

    public static interface Type {
        public String getItemPattern();

        public ListBlock createList(ListItemBlock[] var1);
    }
}

