/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.Arrays;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.sink.Sink;

public abstract class AbstractFatherBlock
implements Block {
    private final Block[] childBlocks;

    public abstract void before(Sink var1);

    public abstract void after(Sink var1);

    public AbstractFatherBlock(Block[] childBlocks) {
        if (childBlocks == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        for (int i = 0; i < childBlocks.length; ++i) {
            if (childBlocks[i] != null) continue;
            throw new IllegalArgumentException("bucket " + i + " can't be null");
        }
        this.childBlocks = childBlocks;
    }

    public final void traverse(Sink sink) {
        this.before(sink);
        for (int i = 0; i < this.childBlocks.length; ++i) {
            Block block = this.childBlocks[i];
            block.traverse(sink);
        }
        this.after(sink);
    }

    public final Block[] getBlocks() {
        return this.childBlocks;
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj == this) {
            ret = true;
        } else if (obj == null) {
            ret = false;
        } else if (obj.getClass().equals(this.getClass()) && obj instanceof AbstractFatherBlock) {
            AbstractFatherBlock a = (AbstractFatherBlock)obj;
            ret = Arrays.equals(a.childBlocks, this.childBlocks);
        }
        return ret;
    }

    public int hashCode() {
        int result = 1;
        if (this.childBlocks != null) {
            for (int i = 0; i < this.childBlocks.length; ++i) {
                result += this.childBlocks[i].hashCode();
            }
        }
        return result;
    }
}

