/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.BlockParser;
import org.apache.maven.doxia.module.twiki.parser.FormatedTextParser;
import org.apache.maven.doxia.module.twiki.parser.GenericListBlockParser;
import org.apache.maven.doxia.module.twiki.parser.HRuleBlockParser;
import org.apache.maven.doxia.module.twiki.parser.ParagraphBlockParser;
import org.apache.maven.doxia.module.twiki.parser.SectionBlock;
import org.apache.maven.doxia.module.twiki.parser.SectionBlockParser;
import org.apache.maven.doxia.module.twiki.parser.State;
import org.apache.maven.doxia.module.twiki.parser.StringLineSource;
import org.apache.maven.doxia.module.twiki.parser.TableBlockParser;
import org.apache.maven.doxia.module.twiki.parser.TextParser;
import org.apache.maven.doxia.parser.AbstractTextParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.ByLineSource;
import org.codehaus.plexus.util.IOUtil;

public class TWikiParser
extends AbstractTextParser {
    private final ParagraphBlockParser paraParser = new ParagraphBlockParser();
    private final SectionBlockParser sectionParser = new SectionBlockParser();
    private final GenericListBlockParser listParser = new GenericListBlockParser();
    private final FormatedTextParser formatTextParser = new FormatedTextParser();
    private final TextParser textParser = new TextParser();
    private final HRuleBlockParser hrulerParser = new HRuleBlockParser();
    private final TableBlockParser tableParser = new TableBlockParser();
    private final BlockParser[] parsers;

    public TWikiParser() {
        this.paraParser.setSectionParser(this.sectionParser);
        this.paraParser.setListParser(this.listParser);
        this.paraParser.setTextParser(this.formatTextParser);
        this.paraParser.setHrulerParser(this.hrulerParser);
        this.paraParser.setTableBlockParser(this.tableParser);
        this.sectionParser.setParaParser(this.paraParser);
        this.sectionParser.setHrulerParser(this.hrulerParser);
        this.listParser.setTextParser(this.formatTextParser);
        this.formatTextParser.setTextParser(this.textParser);
        this.tableParser.setTextParser(this.formatTextParser);
        this.parsers = new BlockParser[]{this.sectionParser, this.hrulerParser, this.paraParser};
    }

    public final List parse(ByLineSource source) throws ParseException {
        String line;
        ArrayList<Block> ret = new ArrayList<Block>();
        while ((line = source.getNextLine()) != null) {
            boolean accepted = false;
            for (int i = 0; i < this.parsers.length; ++i) {
                BlockParser parser = this.parsers[i];
                if (!parser.accept(line)) continue;
                accepted = true;
                ret.add(parser.visit(line, source));
                break;
            }
            if (accepted) continue;
            throw new ParseException("don't  know how to handle line: " + source.getLineNumber() + ": " + line);
        }
        return ret;
    }

    public final synchronized void parse(Reader reader, Sink sink) throws ParseException {
        List blocks;
        String sourceContent;
        try {
            StringWriter contentWriter = new StringWriter();
            IOUtil.copy((Reader)reader, (Writer)contentWriter);
            sourceContent = contentWriter.toString();
        }
        catch (IOException e) {
            throw new ParseException("IOException: " + e.getMessage(), (Exception)e);
        }
        this.textParser.setSourceContent(sourceContent);
        this.textParser.setParent(this);
        State.init();
        StringLineSource source = new StringLineSource(sourceContent);
        try {
            blocks = this.parse(source);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e, source.getName(), source.getLineNumber());
        }
        SectionBlock.clearLevelStack();
        sink.head();
        sink.head_();
        sink.body();
        Iterator it = blocks.iterator();
        while (it.hasNext()) {
            Block block = (Block)it.next();
            block.traverse(sink);
        }
        SectionBlock.closeAllSections(sink);
        sink.body_();
    }

    public boolean isSecondParsing() {
        return this.secondParsing;
    }
}

