/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.cup.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java_cup.ErrorManager;
import java_cup.Main;
import java_cup.runtime.ComplexSymbolFactory;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

@Mojo(name="generate", threadSafe=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CupGenerateMojo
extends AbstractMojo {
    private static final String CUP_EXTENSION = ".cup";
    @Parameter(property="cup.sourceDirectory", defaultValue="${project.basedir}/src/main/cup")
    private File sourceDirectory;
    @Parameter(property="cup.outputDirectory", defaultValue="${project.build.directory}/generated-sources/cup")
    private File outputDirectory;
    @Parameter(property="cup.packageName")
    private String packageName;
    @Parameter(property="cup.className")
    private String className;
    @Parameter(property="cup.typeArgs")
    private String typeArgs;
    @Parameter(property="cup.symbolsName", defaultValue="Sym")
    private String symbolsName;
    @Parameter(property="cup.symbolsInterface", defaultValue="false")
    private boolean symbolsInterface;
    @Parameter(property="cup.nontermsToSymbols", defaultValue="false")
    private boolean nontermsToSymbols;
    @Parameter(property="cup.expectedConflicts", defaultValue="0")
    private int expectedConflicts;
    @Parameter(property="cup.compactRed", defaultValue="false")
    private boolean compactRed;
    @Parameter(property="cup.noWarn", defaultValue="false")
    private boolean noWarn;
    @Parameter(property="cup.noSummary", defaultValue="false")
    private boolean noSummary;
    @Parameter(property="cup.showProgress", defaultValue="false")
    private boolean showProgress;
    @Parameter(property="cup.dumpGrammar", defaultValue="false")
    private boolean dumpGrammar;
    @Parameter(property="cup.dumpStates", defaultValue="false")
    private boolean dumpStates;
    @Parameter(property="cup.dumpTables", defaultValue="false")
    private boolean dumpTables;
    @Parameter(property="cup.timeSummary", defaultValue="false")
    private boolean timeSummary;
    @Parameter(property="cup.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="cup.noPositions", defaultValue="false")
    private boolean noPositions;
    @Parameter(property="cup.noScanner", defaultValue="false")
    private boolean noScanner;
    @Parameter(property="cup.externalTables", defaultValue="false")
    private boolean externalTables;
    @Parameter(property="cup.suppressGeneratedJavaWarningsUnchecked", defaultValue="false")
    private boolean suppressGeneratedJavaWarningsUnchecked;
    @Parameter(property="cup.suppressGeneratedJavaWarningsUnused", defaultValue="false")
    private boolean suppressGeneratedJavaWarningsUnused;
    @Component
    private MavenProject project;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException {
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.outputDirectory.getPath());
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getPath());
            resource.addInclude("**/*.dat");
            this.project.addResource(resource);
        }
        List<File> cupSourceFiles = this.getCupFiles();
        this.getLog().info((CharSequence)("CUP: Processing " + cupSourceFiles.size() + " cup files"));
        for (File file : cupSourceFiles) {
            this.generateCup(file);
        }
    }

    private List<File> getCupFiles() {
        if (this.buildContext == null) {
            this.buildContext = new DefaultBuildContext();
        }
        List<File> allCupFiles = this.getAllCupFiles(new File[]{this.sourceDirectory});
        ArrayList<File> changed = new ArrayList<File>();
        for (File file : allCupFiles) {
            if (!this.buildContext.hasDelta(file)) continue;
            changed.add(file);
        }
        return changed;
    }

    private List<File> getAllCupFiles(File[] files) {
        ArrayList<File> cupFiles = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) {
                cupFiles.addAll(this.getAllCupFiles(file.listFiles()));
                continue;
            }
            if (!file.getName().endsWith(CUP_EXTENSION)) continue;
            cupFiles.add(file);
        }
        return cupFiles;
    }

    private void generateCup(File file) throws MojoExecutionException {
        File destDir;
        String className;
        this.getLog().debug((CharSequence)("CUP: Processing " + file.getPath()));
        this.buildContext.removeMessages(file);
        String packageName = this.packageName;
        if (packageName == null) {
            try {
                packageName = this.getPackageName(file);
            }
            catch (IOException e) {
                this.getLog().debug((Throwable)e);
            }
        }
        if ((className = this.className) == null) {
            String fileName = file.getName();
            className = fileName.endsWith(CUP_EXTENSION) ? fileName.substring(0, fileName.length() - CUP_EXTENSION.length()) : fileName;
        }
        if (!(destDir = packageName != null ? new File(this.outputDirectory, packageName.replace(".", "/")) : this.outputDirectory).exists() && !destDir.mkdirs()) {
            throw new MojoExecutionException("Couldn't create directories for " + destDir.getName());
        }
        File destFile = new File(destDir, className + ".java");
        File symbolsFile = new File(destDir, this.symbolsName + ".java");
        ArrayList<String> args = new ArrayList<String>();
        if (packageName != null) {
            args.add("-package");
            args.add(packageName);
        }
        args.add("-parser");
        args.add(className);
        if (this.typeArgs != null) {
            args.add("-typearg");
            args.add(this.typeArgs);
        }
        if (this.symbolsName != null) {
            args.add("-symbols");
            args.add(this.symbolsName);
        }
        if (this.symbolsInterface) {
            args.add("-interface");
        }
        if (this.nontermsToSymbols) {
            args.add("-nonterms");
        }
        if (this.expectedConflicts > 0) {
            args.add("-expect");
            args.add(String.valueOf(this.expectedConflicts));
        }
        if (this.compactRed) {
            args.add("-compact_red");
        }
        if (this.noWarn) {
            args.add("-nowarn");
        }
        if (this.noSummary) {
            args.add("-nosummary");
        }
        if (this.showProgress) {
            args.add("-progress");
        }
        if (this.dumpGrammar) {
            args.add("-dump_grammar");
        }
        if (this.dumpStates) {
            args.add("-dump_states");
        }
        if (this.dumpTables) {
            args.add("-dump_tables");
        }
        if (this.timeSummary) {
            args.add("-time");
        }
        if (this.debug) {
            args.add("-debug");
        }
        if (this.noPositions) {
            args.add("-nopositions");
        }
        if (this.noScanner) {
            args.add("-noscanner");
        }
        if (this.externalTables) {
            args.add("-external_tables");
        }
        if (this.suppressGeneratedJavaWarningsUnchecked) {
            args.add("-suppress_generated_java_warnings_unchecked");
        }
        if (this.suppressGeneratedJavaWarningsUnused) {
            args.add("-suppress_generated_java_warnings_unused");
        }
        args.add("-destdir");
        args.add(destDir.getAbsolutePath());
        args.add(file.getAbsolutePath());
        try {
            Main.main((String[])args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            throw new MojoExecutionException("CUP generation failed: " + e.getMessage(), e);
        }
        finally {
            this.logCupMessages(file);
        }
        this.refreshFile(destFile);
        this.refreshFile(symbolsFile);
        File[] listFiles = destDir.listFiles();
        if (listFiles != null) {
            for (File resourceFile : listFiles) {
                if (!resourceFile.getName().endsWith(".dat")) continue;
                this.refreshFile(resourceFile);
            }
        } else {
            throw new MojoExecutionException("Couldn't get destination directory list of files - " + destDir.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPackageName(File cupFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cupFile), StandardCharsets.US_ASCII));){
            String line = "";
            while ((line = reader.readLine()) != null) {
                int packageNameIndex;
                int packageNameEnd;
                int packageIndex = line.indexOf("package");
                if (packageIndex < 0 || (packageNameEnd = line.indexOf(59, packageNameIndex = (packageIndex += 7))) < packageNameIndex) continue;
                String string = line.substring(packageNameIndex, packageNameEnd).trim();
                return string;
            }
        }
        return null;
    }

    private void refreshFile(File targetFile) {
        this.buildContext.refresh(targetFile);
        this.getLog().info((CharSequence)("CUP: generated " + targetFile));
    }

    private void logCupMessages(File targetFile) {
        ErrorManager log = ErrorManager.getManager();
        this.logCupMessages(targetFile, log.getFatals(), 2);
        this.logCupMessages(targetFile, log.getErrors(), 2);
        this.logCupMessages(targetFile, log.getWarnings(), 1);
    }

    private void logCupMessages(File targetFile, List<ErrorManager.CupLogMessage> msgs, int severity) {
        if (msgs.isEmpty()) {
            return;
        }
        for (ErrorManager.CupLogMessage msg : msgs) {
            int column;
            int line;
            ComplexSymbolFactory.Location loc = msg.getLeftLoc();
            if (loc != null) {
                line = loc.getLine();
                column = loc.getColumn();
            } else {
                line = 0;
                column = 0;
            }
            this.buildContext.addMessage(targetFile, line, column, msg.getMessage(), severity, null);
        }
    }
}

