/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.RegisteredPredicate;
import org.kitesdk.shaded.com.google.common.base.Function;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.kitesdk.shaded.com.google.common.base.Splitter;
import org.kitesdk.shaded.com.google.common.collect.ImmutableSet;
import org.kitesdk.shaded.com.google.common.collect.Iterables;
import org.kitesdk.shaded.com.google.common.collect.Sets;

@Deprecated
public class In<T>
extends RegisteredPredicate<T> {
    private static final String IN = "in";
    private final Set<T> set;

    public static <T> In<T> fromString(String set, Schema schema) {
        LinkedHashSet values = Sets.newLinkedHashSet();
        for (String value : Splitter.on(',').split(set)) {
            values.add(SchemaUtil.fromString(value, schema));
        }
        return Predicates.in(values);
    }

    In(Iterable<T> values) {
        this.set = ImmutableSet.copyOf(values);
        Preconditions.checkArgument(this.set.size() > 0, "No values to match");
    }

    In(T ... values) {
        this.set = ImmutableSet.copyOf(values);
    }

    In(Set<T> set) {
        this.set = set;
    }

    @Override
    public String getName() {
        return IN;
    }

    @Override
    public boolean apply(@Nullable T test) {
        return test != null && this.set.contains(test);
    }

    public In<T> filter(Predicate<? super T> predicate) {
        try {
            return new In<T>(Iterables.filter(this.set, predicate));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Filter predicate produces empty set", e);
        }
    }

    public <V> In<V> transform(Function<? super T, V> function) {
        return new In<V>(Iterables.transform(this.set, function));
    }

    Set<T> getSet() {
        return this.set;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equal(this.set, ((In)o).set);
    }

    public int hashCode() {
        return Objects.hashCode(this.set);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("set", this.set).toString();
    }

    @Override
    public String toString(Schema schema) {
        return Joiner.on(',').join(Iterables.transform(this.set, new ToString(schema)));
    }

    @Override
    public String toNormalizedString(Schema schema) {
        Iterable strings = Iterables.transform(this.set, new ToString(schema));
        return Joiner.on(',').join(Sets.newTreeSet(strings));
    }

    static {
        RegisteredPredicate.register(IN, new RegisteredPredicate.Factory(){

            public <V> RegisteredPredicate<V> fromString(String values, Schema schema) {
                return In.fromString(values, schema);
            }
        });
    }

    private static class ToString<T>
    implements Function<T, String> {
        private final Schema schema;

        private ToString(Schema schema) {
            this.schema = schema;
        }

        @Override
        public String apply(@Nullable T input) {
            return SchemaUtil.toString(input, this.schema);
        }
    }
}

