/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashSet;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.kitesdk.shaded.com.google.common.collect.DiscreteDomains;
import org.kitesdk.shaded.com.google.common.collect.Sets;

@Deprecated
@SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="False positive due to generics.")
@Immutable
public class LongFixedSizeRangeFieldPartitioner
extends FieldPartitioner<Long, Long> {
    private final long size;

    public LongFixedSizeRangeFieldPartitioner(String sourceName, long size) {
        this(sourceName, null, size);
    }

    public LongFixedSizeRangeFieldPartitioner(String sourceName, @Nullable String name, long size) {
        super(sourceName, name == null ? sourceName + "_range" : name, Long.class, Long.class);
        this.size = size;
        Preconditions.checkArgument(size > 0L, "Size of range buckets is not positive: %s", size);
    }

    @Override
    public Long apply(Long value) {
        return Math.round(Math.floor((double)value.longValue() / (double)this.size)) * this.size;
    }

    @Override
    public Predicate<Long> project(Predicate<Long> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            return ((In)predicate).transform(this);
        }
        if (predicate instanceof Range) {
            return Ranges.transformClosed(Ranges.adjustClosed((Range)predicate, DiscreteDomains.longs()), this);
        }
        return null;
    }

    @Override
    public Predicate<Long> projectStrict(Predicate<Long> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            HashSet<Long> possibleValues = Sets.newHashSet();
            In<Long> in = ((In)predicate).transform(this);
            for (Long val : Predicates.asSet(in)) {
                boolean matchedAll = true;
                for (long i = 0L; i < this.size; ++i) {
                    matchedAll = matchedAll && predicate.apply(val + i);
                }
                if (!matchedAll) continue;
                possibleValues.add(val);
            }
            if (!possibleValues.isEmpty()) {
                return Predicates.in(possibleValues);
            }
        } else if (predicate instanceof Range) {
            Range<Long> closed = Ranges.adjustClosed((Range)predicate, DiscreteDomains.longs());
            Long start = null;
            if (closed.hasLowerBound()) {
                start = closed.lowerEndpoint() % this.size == 0L ? closed.lowerEndpoint() : this.apply(closed.lowerEndpoint() + this.size);
            }
            Long end = null;
            if (closed.hasUpperBound()) {
                end = (closed.upperEndpoint() + 1L) % this.size == 0L ? this.apply(closed.upperEndpoint()) : this.apply(closed.upperEndpoint() - this.size);
            }
            if (start != null && end != null && start > end) {
                return null;
            }
            return Ranges.closed(start, end);
        }
        return null;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    @SuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Default annotation is not correct for equals")
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        LongFixedSizeRangeFieldPartitioner that = (LongFixedSizeRangeFieldPartitioner)o;
        return Objects.equal(this.getName(), that.getName()) && Objects.equal(this.size, that.size);
    }

    @Override
    public int compare(Long o1, Long o2) {
        return this.apply(o1).compareTo(this.apply(o2));
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), this.size);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.getName()).add("size", this.size).toString();
    }
}

