/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashSet;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.kitesdk.shaded.com.google.common.collect.DiscreteDomains;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.kitesdk.shaded.com.google.common.primitives.Ints;

@Deprecated
@SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="Implement if we intend to use in Serializable objects  (e.g., TreeMaps) and use java serialization.")
@Immutable
public class IntRangeFieldPartitioner
extends FieldPartitioner<Integer, Integer> {
    private final int[] upperBounds;

    public IntRangeFieldPartitioner(String sourceName, int ... upperBounds) {
        this(sourceName, null, upperBounds);
    }

    public IntRangeFieldPartitioner(String sourceName, @Nullable String name, int ... upperBounds) {
        super(sourceName, name == null ? sourceName + "_bound" : name, Integer.class, Integer.class, upperBounds.length);
        this.upperBounds = upperBounds;
    }

    @Override
    public Integer apply(Integer value) {
        for (int i = 0; i < this.upperBounds.length; ++i) {
            if (value > this.upperBounds[i]) continue;
            return i;
        }
        throw new IllegalArgumentException(value + " is outside bounds");
    }

    @Override
    public Predicate<Integer> project(Predicate<Integer> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            return ((In)predicate).transform(this);
        }
        if (predicate instanceof Range) {
            return Ranges.transformClosed(Ranges.adjustClosed((Range)predicate, DiscreteDomains.integers()), this);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Predicate<Integer> projectStrict(Predicate<Integer> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            HashSet<Integer> possibleValues = Sets.newHashSet();
            int end = this.upperBounds[this.upperBounds.length - 1];
            int nextIndex = 1;
            boolean matchedAll = true;
            for (int i = this.upperBounds[0] + 1; i <= end; ++i) {
                boolean bl = matchedAll = matchedAll && predicate.apply(i);
                if (i != this.upperBounds[nextIndex]) continue;
                if (matchedAll) {
                    possibleValues.add(nextIndex);
                }
                matchedAll = true;
                ++nextIndex;
            }
            if (possibleValues.isEmpty()) return null;
            return Predicates.in(possibleValues);
        }
        if (!(predicate instanceof Range)) return null;
        Range<Integer> adjusted = Ranges.adjustClosed((Range)predicate, DiscreteDomains.integers());
        if (adjusted.hasLowerBound()) {
            int lower = adjusted.lowerEndpoint();
            int lowerIndex = this.apply(lower);
            if (lowerIndex == 0 || this.upperBounds[lowerIndex - 1] < lower - 1) {
                ++lowerIndex;
            }
            if (!adjusted.hasUpperBound()) return Ranges.atLeast(lowerIndex);
            int upper = adjusted.upperEndpoint();
            int upperIndex = this.apply(upper);
            if (this.upperBounds[upperIndex] > upper + 1) {
                --upperIndex;
            }
            if (lowerIndex > upperIndex) return null;
            return Ranges.closed(lowerIndex, upperIndex);
        }
        if (!adjusted.hasUpperBound()) return null;
        int upper = adjusted.upperEndpoint();
        int upperIndex = this.apply(upper);
        if (this.upperBounds[upperIndex] <= upper + 1) return Ranges.atMost(upperIndex);
        --upperIndex;
        return Ranges.atMost(upperIndex);
    }

    int[] getUpperBounds() {
        return this.upperBounds;
    }

    @Override
    @SuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Default annotation is not correct for equals")
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        IntRangeFieldPartitioner that = (IntRangeFieldPartitioner)o;
        return Objects.equal(this.getName(), that.getName()) && Objects.equal(Ints.asList(this.upperBounds), Ints.asList(that.upperBounds));
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return this.apply(o1).compareTo(this.apply(o2));
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), Ints.asList(this.upperBounds));
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.getName()).add("upperBounds", Ints.asList(this.upperBounds)).toString();
    }
}

