/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Calendar;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Predicate;

@Deprecated
@SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="False positive due to generics.")
@Immutable
public class CalendarFieldPartitioner
extends FieldPartitioner<Long, Integer> {
    protected static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    protected final int calendarField;

    public CalendarFieldPartitioner(String sourceName, String name, int calendarField, int cardinality) {
        super(sourceName, name, Long.class, Integer.class, cardinality);
        this.calendarField = calendarField;
    }

    @Override
    public Integer apply(@Nonnull Long timestamp) {
        Calendar cal = Calendar.getInstance(UTC);
        cal.setTimeInMillis(timestamp);
        return cal.get(this.calendarField);
    }

    @Override
    public Predicate<Integer> project(Predicate<Long> predicate) {
        return null;
    }

    @Override
    public Predicate<Integer> projectStrict(Predicate<Long> predicate) {
        return null;
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    @Override
    @SuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Default annotation is not correct for equals")
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CalendarFieldPartitioner that = (CalendarFieldPartitioner)o;
        return Objects.equal(this.getSourceName(), that.getSourceName()) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getCardinality(), that.getCardinality());
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceName(), this.getName(), this.getCardinality());
    }

    public String toString() {
        return Objects.toStringHelper(this).add("sourceName", this.getSourceName()).add("name", this.getName()).add("cardinality", this.getCardinality()).toString();
    }
}

