/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Formats;
import org.kitesdk.data.spi.filesystem.FileSystemWriter;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.io.Closeables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParquetAppender<E extends IndexedRecord>
implements FileSystemWriter.FileAppender<E> {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetAppender.class);
    private static final int DEFAULT_ROW_GROUP_SIZE = 0x3200000;
    private final Path path;
    private final Schema schema;
    private final FileSystem fileSystem;
    private final Configuration conf;
    private final boolean enableCompression;
    private final CompressionType compressionType;
    private AvroParquetWriter<E> avroParquetWriter = null;

    public ParquetAppender(FileSystem fileSystem, Path path, Schema schema, Configuration conf, CompressionType compressionType) {
        this.fileSystem = fileSystem;
        this.path = path;
        this.schema = schema;
        this.conf = conf;
        this.enableCompression = compressionType != CompressionType.Uncompressed;
        this.compressionType = compressionType;
    }

    @Override
    public void open() throws IOException {
        CompressionCodecName codecName = CompressionCodecName.UNCOMPRESSED;
        if (this.enableCompression) {
            codecName = this.getCompressionCodecName();
        }
        this.avroParquetWriter = new AvroParquetWriter(this.fileSystem.makeQualified(this.path), this.schema, codecName, 0x3200000, 0x100000, true, this.conf);
    }

    @Override
    public void append(E entity) throws IOException {
        this.avroParquetWriter.write(entity);
    }

    @Override
    public long pos() throws IOException {
        return this.avroParquetWriter.getDataSize();
    }

    @Override
    public void flush() {
    }

    @Override
    public void sync() {
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.avroParquetWriter, false);
    }

    @Override
    public void cleanup() throws IOException {
    }

    public String toString() {
        return Objects.toStringHelper(this).add("path", this.path).add("schema", this.schema).add("fileSystem", this.fileSystem).add("avroParquetWriter", this.avroParquetWriter).toString();
    }

    private CompressionCodecName getCompressionCodecName() {
        switch (this.compressionType) {
            case Snappy: {
                return CompressionCodecName.SNAPPY;
            }
            case Lzo: {
                return CompressionCodecName.LZO;
            }
            case Deflate: {
                return CompressionCodecName.GZIP;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported compression format %s. Supported formats: %s", this.compressionType.getName(), Arrays.toString(Formats.PARQUET.getSupportedCompressionTypes().toArray())));
    }
}

