/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.filesystem.JSONFileReader;

class JSONInputFormat<E>
extends FileInputFormat<E, Void> {
    private EntityAccessor<E> accessor = null;

    JSONInputFormat() {
    }

    public void setView(View<E> view) {
        this.accessor = DataModelUtil.accessor(view.getType(), view.getSchema());
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        return super.getSplits(job);
    }

    public RecordReader<E, Void> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = (Configuration)Hadoop.TaskAttemptContext.getConfiguration.invoke((Object)context, new Object[0]);
        if (!(split instanceof FileSplit)) {
            throw new DatasetOperationException("Split is not a FileSplit: %s:%s", split.getClass().getCanonicalName(), split);
        }
        Path path = ((FileSplit)split).getPath();
        JSONFileReader<E> reader = new JSONFileReader<E>(path.getFileSystem(conf), path, this.accessor);
        reader.initialize();
        return reader.asRecordReader();
    }
}

