/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.PartitionView;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.PartitionListener;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemView;
import org.kitesdk.data.spi.filesystem.PathConversion;
import org.kitesdk.data.spi.filesystem.SignalManager;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.kitesdk.shaded.com.google.common.base.Predicates;
import org.kitesdk.shaded.com.google.common.base.Splitter;
import org.kitesdk.shaded.com.google.common.collect.Iterables;

@Immutable
class FileSystemPartitionView<E>
extends FileSystemView<E>
implements PartitionView<E> {
    private static final Splitter PATH_SPLITTER = Splitter.on('/');
    private final Path location;
    private final URI relativeLocation;

    FileSystemPartitionView(FileSystemDataset<E> dataset, @Nullable PartitionListener partitionListener, @Nullable SignalManager signalManager, Class<E> type) {
        super(dataset, partitionListener, signalManager, type);
        this.location = dataset.getDirectory();
        this.relativeLocation = null;
    }

    static <E> FileSystemPartitionView<E> getPartition(FileSystemPartitionView<E> base, URI location) {
        URI relative = FileSystemPartitionView.relativize(URI.create(base.root.toString()), location);
        if (relative == null) {
            return base;
        }
        return new FileSystemPartitionView<E>(base, relative);
    }

    static <E> FileSystemPartitionView<E> getPartition(FileSystemPartitionView<E> base, Path location) {
        URI relative = FileSystemPartitionView.relativize(URI.create(base.root.toString()), location == null ? null : URI.create(location.toString()));
        if (relative == null) {
            return base;
        }
        return new FileSystemPartitionView<E>(base, relative);
    }

    private FileSystemPartitionView(FileSystemPartitionView<E> view, URI relativeLocation) {
        super(view, FileSystemPartitionView.constraints(view, relativeLocation));
        this.location = new Path(view.root, relativeLocation.toString());
        this.relativeLocation = relativeLocation;
    }

    @Override
    public URI getLocation() {
        return URI.create(this.location.toString());
    }

    URI getRelativeLocation() {
        return this.relativeLocation;
    }

    FileSystemView<E> toConstraintsView() {
        return this.filter(this.constraints);
    }

    @Override
    public Iterable<PartitionView<E>> getCoveringPartitions() {
        return Iterables.filter(super.getCoveringPartitions(), new Predicate<PartitionView<E>>(){

            @Override
            public boolean apply(@Nullable PartitionView<E> input) {
                return input != null && FileSystemPartitionView.contains(URI.create(FileSystemPartitionView.this.location.toString()), FileSystemPartitionView.this.root, input.getLocation());
            }
        });
    }

    @Override
    public boolean deleteAll() {
        return this.deleteAllUnsafe();
    }

    @Override
    protected Predicate<StorageKey> getKeyPredicate() {
        if (this.relativeLocation == null) {
            return Predicates.alwaysTrue();
        }
        return new PartitionKeyPredicate(this.root, this.location);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileSystemPartitionView that = (FileSystemPartitionView)other;
        return Objects.equal(this.location, that.location);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.location);
    }

    private static boolean contains(URI location, Path root, URI relative) {
        URI full = new Path(root, relative.getPath()).toUri();
        return !location.relativize(full).isAbsolute();
    }

    @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Null value checked by precondition")
    private static URI relativize(@Nullable URI root, @Nullable URI location) {
        URI relative;
        Preconditions.checkNotNull(root, "Cannot find location relative to null");
        if (location == null) {
            return null;
        }
        String scheme = location.getScheme();
        String path = location.getRawPath();
        if (scheme == null && !path.startsWith("/")) {
            relative = location;
        } else {
            String rootScheme = root.getScheme();
            Preconditions.checkArgument(scheme == null || rootScheme == null || scheme.equals(rootScheme), "%s is not contained in %s", location, root);
            URI rootPath = URI.create(root.getRawPath());
            relative = rootPath.relativize(URI.create(path));
            if (relative.getPath().isEmpty()) {
                return null;
            }
        }
        String relativePath = relative.getRawPath();
        if (relativePath.endsWith("/")) {
            relative = URI.create(relativePath.substring(0, relativePath.length() - 1));
        }
        Preconditions.checkArgument(!relative.getPath().startsWith("/"), "%s is not contained in %s", location, root);
        return relative;
    }

    private static Constraints constraints(FileSystemPartitionView<?> view, @Nullable URI relative) {
        DatasetDescriptor descriptor = view.dataset.getDescriptor();
        if (relative == null) {
            return view.constraints;
        }
        Preconditions.checkArgument(descriptor.isPartitioned(), "Dataset is not partitioned");
        Constraints constraints = view.constraints;
        Schema schema = descriptor.getSchema();
        PartitionStrategy strategy = descriptor.getPartitionStrategy();
        PathConversion conversion = new PathConversion(schema);
        Iterator<String> parts = PATH_SPLITTER.split(relative.getRawPath()).iterator();
        for (FieldPartitioner fp : Accessor.getDefault().getFieldPartitioners(strategy)) {
            if (!parts.hasNext()) break;
            constraints = constraints.with(fp.getName(), conversion.valueForDirname(fp, parts.next()));
        }
        Preconditions.checkArgument(!parts.hasNext(), "%s is deeper than the partition strategy", relative);
        return constraints;
    }

    private static class PartitionKeyPredicate
    implements Predicate<StorageKey> {
        private final Path root;
        private final URI location;

        public PartitionKeyPredicate(Path root, Path location) {
            this.root = root;
            this.location = location.toUri();
        }

        @Override
        public boolean apply(@Nullable StorageKey key) {
            return key != null && key.getPath() != null && FileSystemPartitionView.contains(this.location, this.root, key.getPath().toUri());
        }
    }
}

