/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetExistsException;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.AbstractMetadataProvider;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.kitesdk.data.spi.filesystem.PathFilters;
import org.kitesdk.data.spi.filesystem.SchemaManager;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;
import org.kitesdk.shaded.com.google.common.base.Charsets;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.kitesdk.shaded.com.google.common.io.Closeables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileSystemMetadataProvider
extends AbstractMetadataProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemMetadataProvider.class);
    private static final String METADATA_DIRECTORY = ".metadata";
    private static final String SCHEMA_FILE_NAME = "schema.avsc";
    private static final String SCHEMA_DIRECTORY_NAME = "schemas";
    private static final String DESCRIPTOR_FILE_NAME = "descriptor.properties";
    private static final String PARTITION_EXPRESSION_FIELD_NAME = "partitionExpression";
    private static final String VERSION_FIELD_NAME = "version";
    private static final String METADATA_VERSION = "1";
    private static final String FORMAT_FIELD_NAME = "format";
    private static final String LOCATION_FIELD_NAME = "location";
    private static final String COMPRESSION_TYPE_FIELD_NAME = "compressionType";
    private static final String DEFAULT_NAMESPACE = "default";
    private static final Set<String> RESERVED_PROPERTIES = Sets.newHashSet("partitionExpression", "version", "format", "location", "compressionType");
    private final Configuration conf;
    private final Path rootDirectory;
    private final transient FileSystem rootFileSystem;

    public FileSystemMetadataProvider(Configuration conf, Path rootDirectory) {
        Preconditions.checkNotNull(conf, "Configuration cannot be null");
        Preconditions.checkNotNull(rootDirectory, "Root directory cannot be null");
        this.conf = conf;
        try {
            this.rootFileSystem = rootDirectory.getFileSystem(conf);
            this.rootDirectory = this.rootFileSystem.makeQualified(rootDirectory);
        }
        catch (IOException ex) {
            throw new DatasetIOException("Cannot get FileSystem for root path", ex);
        }
    }

    @Override
    public DatasetDescriptor load(String namespace, String name) {
        URI schemaURI;
        SchemaManager manager;
        Preconditions.checkNotNull(namespace, "Namespace cannot be null");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        LOG.debug("Loading dataset metadata name: {}", (Object)name);
        Path metadataPath = this.find(namespace, name);
        FSDataInputStream inputStream = null;
        Properties properties = new Properties();
        DatasetDescriptor.Builder builder = new DatasetDescriptor.Builder();
        Path descriptorPath = new Path(metadataPath, DESCRIPTOR_FILE_NAME);
        boolean threw = true;
        try {
            inputStream = this.rootFileSystem.open(descriptorPath);
            properties.load((InputStream)inputStream);
            threw = false;
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to load descriptor file:" + descriptorPath + " for dataset:" + name, e);
        }
        finally {
            try {
                Closeables.close((Closeable)inputStream, threw);
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot close", e);
            }
        }
        if (properties.containsKey(FORMAT_FIELD_NAME)) {
            builder.format(Accessor.getDefault().newFormat(properties.getProperty(FORMAT_FIELD_NAME)));
        }
        if (properties.containsKey(COMPRESSION_TYPE_FIELD_NAME)) {
            builder.compressionType(properties.getProperty(COMPRESSION_TYPE_FIELD_NAME));
        }
        if (properties.containsKey(PARTITION_EXPRESSION_FIELD_NAME)) {
            builder.partitionStrategy(Accessor.getDefault().fromExpression(properties.getProperty(PARTITION_EXPRESSION_FIELD_NAME)));
        }
        if ((manager = SchemaManager.load(this.conf, new Path(metadataPath, SCHEMA_DIRECTORY_NAME))) == null) {
            Path schemaPath = new Path(metadataPath, SCHEMA_FILE_NAME);
            FileSystemMetadataProvider.checkExists(this.getFileSytem(), schemaPath);
            schemaURI = this.rootFileSystem.makeQualified(schemaPath).toUri();
        } else {
            schemaURI = manager.getNewestSchemaURI();
        }
        if (schemaURI == null) {
            throw new DatasetException("Maformed dataset metadata at " + metadataPath + ". No schemas are present.");
        }
        try {
            builder.schemaUri(schemaURI);
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to load schema file:" + schemaURI + " for dataset:" + name, e);
        }
        Path location = properties.containsKey(LOCATION_FIELD_NAME) ? new Path(properties.getProperty(LOCATION_FIELD_NAME)) : this.expectedPathForDataset(namespace, name);
        builder.location(location);
        for (String property : properties.stringPropertyNames()) {
            if (RESERVED_PROPERTIES.contains(property)) continue;
            builder.property(property, properties.getProperty(property));
        }
        return builder.build();
    }

    @Override
    public DatasetDescriptor create(String namespace, String name, DatasetDescriptor descriptor) {
        Preconditions.checkNotNull(namespace, "Namespace cannot be null");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        Preconditions.checkNotNull(descriptor, "Descriptor cannot be null");
        Compatibility.check(namespace, name, descriptor);
        LOG.debug("Saving dataset metadata name:{} descriptor:{}", (Object)name, (Object)descriptor);
        Path metadataLocation = this.pathForMetadata(namespace, name);
        try {
            if (this.rootFileSystem.exists(metadataLocation)) {
                throw new DatasetExistsException("Descriptor directory already exists: " + metadataLocation);
            }
            this.rootFileSystem.mkdirs(metadataLocation);
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to create metadata directory: " + metadataLocation + " for dataset: " + name, e);
        }
        FileSystemMetadataProvider.writeDescriptor(this.rootFileSystem, metadataLocation, name, descriptor);
        return descriptor;
    }

    @Override
    public DatasetDescriptor update(String namespace, String name, DatasetDescriptor descriptor) {
        Preconditions.checkNotNull(namespace, "Namespace cannot be null");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        Preconditions.checkNotNull(descriptor, "Descriptor cannot be null");
        Compatibility.check(namespace, name, descriptor);
        LOG.debug("Saving dataset metadata name: {} descriptor: {}", (Object)name, (Object)descriptor);
        Path metadataPath = this.find(namespace, name);
        FileSystemMetadataProvider.writeDescriptor(this.rootFileSystem, metadataPath, name, descriptor);
        return descriptor;
    }

    @Override
    public boolean delete(String namespace, String name) {
        Path metadataDirectory;
        Preconditions.checkNotNull(namespace, "Namespace cannot be null");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        LOG.debug("Deleting dataset metadata name: {}", (Object)name);
        try {
            metadataDirectory = this.find(namespace, name);
        }
        catch (DatasetNotFoundException e) {
            return false;
        }
        try {
            if (this.rootFileSystem.exists(metadataDirectory)) {
                if (this.rootFileSystem.delete(metadataDirectory, true)) {
                    return true;
                }
                throw new IOException("Failed to delete metadata directory:" + metadataDirectory);
            }
            return false;
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to find or delete metadata directory:" + metadataDirectory + " for dataset:" + name, e);
        }
    }

    @Override
    public boolean exists(String namespace, String name) {
        Preconditions.checkNotNull(namespace, "Namespace cannot be null");
        Preconditions.checkNotNull(name, "Dataset name cannot be null");
        try {
            this.find(namespace, name);
            return true;
        }
        catch (DatasetNotFoundException e) {
            return false;
        }
    }

    public Set<String> namespaces() {
        HashSet<String> namespaces = Sets.newHashSet();
        try {
            FileStatus[] entries;
            for (FileStatus entry : entries = this.rootFileSystem.listStatus(this.rootDirectory, PathFilters.notHidden())) {
                if (!entry.isDir()) continue;
                if (this.isNamespace(entry.getPath())) {
                    namespaces.add(entry.getPath().getName());
                    continue;
                }
                if (!this.isDataset(entry.getPath())) continue;
                namespaces.add(DEFAULT_NAMESPACE);
            }
        }
        catch (FileNotFoundException ex) {
            return namespaces;
        }
        catch (IOException ex) {
            throw new DatasetIOException("Could not list namespaces", ex);
        }
        return namespaces;
    }

    public Set<String> datasets(String namespace) {
        Preconditions.checkNotNull(namespace, "Namespace cannot be null");
        HashSet<String> datasets = Sets.newHashSet();
        try {
            if (DEFAULT_NAMESPACE.equals(namespace)) {
                FileStatus[] directEntries;
                for (FileStatus entry : directEntries = this.rootFileSystem.listStatus(this.rootDirectory, PathFilters.notHidden())) {
                    if (!entry.isDir() || !this.isDataset(entry.getPath())) continue;
                    datasets.add(entry.getPath().getName());
                }
            }
        }
        catch (FileNotFoundException e) {
            return datasets;
        }
        catch (IOException ex) {
            throw new DatasetIOException("Could not list datasets", ex);
        }
        try {
            FileStatus[] entries;
            for (FileStatus entry : entries = this.rootFileSystem.listStatus(new Path(this.rootDirectory, namespace), PathFilters.notHidden())) {
                if (!entry.isDir() || !this.isDataset(entry.getPath())) continue;
                datasets.add(entry.getPath().getName());
            }
        }
        catch (FileNotFoundException ex) {
            return datasets;
        }
        catch (IOException ex) {
            throw new DatasetIOException("Could not list datasets", ex);
        }
        return datasets;
    }

    private boolean isNamespace(Path dir) throws IOException {
        FileStatus[] stats;
        for (FileStatus stat : stats = this.rootFileSystem.listStatus(dir, PathFilters.notHidden())) {
            if (!stat.isDir() || !this.isDataset(stat.getPath())) continue;
            return true;
        }
        return false;
    }

    private boolean isDataset(Path dir) throws IOException {
        return this.rootFileSystem.isDirectory(new Path(dir, METADATA_DIRECTORY));
    }

    Path getRootDirectory() {
        return this.rootDirectory;
    }

    FileSystem getFileSytem() {
        return this.rootFileSystem;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("rootDirectory", this.rootDirectory).add("conf", this.conf).toString();
    }

    private Path expectedPathForDataset(String namespace, String name) {
        return this.rootFileSystem.makeQualified(FileSystemDatasetRepository.pathForDataset(this.rootDirectory, namespace, name));
    }

    private Path pathForMetadata(String namespace, String name) {
        return FileSystemMetadataProvider.pathForMetadata(this.rootDirectory, namespace, name);
    }

    @VisibleForTesting
    static void writeDescriptor(FileSystem fs, Path metadataLocation, String name, DatasetDescriptor descriptor) {
        FileSystemMetadataProvider.checkExists(fs, metadataLocation);
        FSDataOutputStream outputStream = null;
        Path schemaPath = new Path(metadataLocation, SCHEMA_FILE_NAME);
        boolean threw = true;
        try {
            outputStream = fs.create(schemaPath, true);
            outputStream.write(descriptor.getSchema().toString(true).getBytes(Charsets.UTF_8));
            outputStream.flush();
            threw = false;
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to save schema file: " + schemaPath + " for dataset: " + name, e);
        }
        finally {
            try {
                Closeables.close((Closeable)outputStream, threw);
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot close", e);
            }
        }
        SchemaManager manager = SchemaManager.create(fs.getConf(), new Path(metadataLocation, SCHEMA_DIRECTORY_NAME));
        manager.writeSchema(descriptor.getSchema());
        Properties properties = new Properties();
        properties.setProperty(VERSION_FIELD_NAME, METADATA_VERSION);
        properties.setProperty(FORMAT_FIELD_NAME, descriptor.getFormat().getName());
        properties.setProperty(COMPRESSION_TYPE_FIELD_NAME, descriptor.getCompressionType().getName());
        URI dataLocation = descriptor.getLocation();
        if (dataLocation != null) {
            properties.setProperty(LOCATION_FIELD_NAME, dataLocation.toString());
        }
        if (descriptor.isPartitioned()) {
            properties.setProperty(PARTITION_EXPRESSION_FIELD_NAME, Accessor.getDefault().toExpression(descriptor.getPartitionStrategy()));
        }
        for (String property : descriptor.listProperties()) {
            properties.setProperty(property, descriptor.getProperty(property));
        }
        Path descriptorPath = new Path(metadataLocation, DESCRIPTOR_FILE_NAME);
        threw = true;
        try {
            outputStream = fs.create(descriptorPath, true);
            properties.store((OutputStream)outputStream, "Dataset descriptor for " + name);
            outputStream.flush();
            threw = false;
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to save descriptor file: " + descriptorPath + " for dataset: " + name, e);
        }
        finally {
            try {
                Closeables.close((Closeable)outputStream, threw);
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot close", e);
            }
        }
    }

    private static Path pathForMetadata(Path root, String namespace, String name) {
        return new Path(FileSystemDatasetRepository.pathForDataset(root, namespace, name), METADATA_DIRECTORY);
    }

    private static void checkExists(FileSystem fs, Path location) {
        try {
            if (!fs.exists(location)) {
                throw new DatasetNotFoundException("Descriptor location does not exist: " + location);
            }
        }
        catch (IOException ex) {
            throw new DatasetIOException("Cannot access descriptor location: " + location, ex);
        }
    }

    private Path find(String namespace, String name) {
        Path expectedPath = this.pathForMetadata(namespace, name);
        if (DEFAULT_NAMESPACE.equals(namespace)) {
            try {
                FileSystemMetadataProvider.checkExists(this.rootFileSystem, expectedPath);
                return expectedPath;
            }
            catch (DatasetNotFoundException e) {
                try {
                    Path backwardCompatiblePath = new Path(this.rootDirectory, new Path(name.replace('.', '/'), METADATA_DIRECTORY));
                    FileSystemMetadataProvider.checkExists(this.rootFileSystem, backwardCompatiblePath);
                    return backwardCompatiblePath;
                }
                catch (DatasetNotFoundException ee) {
                    throw e;
                }
            }
        }
        FileSystemMetadataProvider.checkExists(this.rootFileSystem, expectedPath);
        return expectedPath;
    }
}

