/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.data.spi.filesystem.AvroFSInput;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSystemDatasetReader<E>
extends AbstractDatasetReader<E> {
    private final FileSystem fileSystem;
    private final Path path;
    private final Schema schema;
    private final Class<E> type;
    private ReaderWriterState state;
    private DataFileReader<E> reader;
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemDatasetReader.class);

    public FileSystemDatasetReader(FileSystem fileSystem, Path path, Schema schema, Class<E> type) {
        Preconditions.checkArgument(fileSystem != null, "FileSystem cannot be null");
        Preconditions.checkArgument(path != null, "Path cannot be null");
        Preconditions.checkArgument(schema != null, "Schema cannot be null");
        this.fileSystem = fileSystem;
        this.path = path;
        this.schema = schema;
        this.type = type;
        this.state = ReaderWriterState.NEW;
    }

    @Override
    public void initialize() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.NEW), "A reader may not be opened more than once - current state:%s", new Object[]{this.state});
        LOG.debug("Opening reader on path:{}", (Object)this.path);
        try {
            this.reader = new DataFileReader((SeekableInput)new AvroFSInput(this.fileSystem.open(this.path), this.fileSystem.getFileStatus(this.path).getLen()), DataModelUtil.getDatumReaderForType(this.type, this.schema));
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to create reader path:" + this.path, e);
        }
        this.state = ReaderWriterState.OPEN;
    }

    @Override
    public boolean hasNext() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to read from a file in state:%s", new Object[]{this.state});
        return this.reader.hasNext();
    }

    @Override
    public E next() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to read from a file in state:%s", new Object[]{this.state});
        E record = DataModelUtil.createRecord(this.type, this.schema);
        try {
            return (E)this.reader.next(record);
        }
        catch (IOException ex) {
            throw new DatasetIOException("Cannot advance reader", ex);
        }
    }

    @Override
    public void close() {
        if (!this.state.equals((Object)ReaderWriterState.OPEN)) {
            return;
        }
        LOG.debug("Closing reader on path:{}", (Object)this.path);
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to close reader path:" + this.path, e);
        }
        this.state = ReaderWriterState.CLOSED;
    }

    @Override
    public boolean isOpen() {
        return this.state.equals((Object)ReaderWriterState.OPEN);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("fileSystem", this.fileSystem).add("path", this.path).add("schema", this.schema).add("state", (Object)this.state).add("reader", this.reader).toString();
    }
}

