/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.Formats;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.PartitionView;
import org.kitesdk.data.RefinableView;
import org.kitesdk.data.Signalable;
import org.kitesdk.data.View;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.AbstractDataset;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.InputFormatAccessor;
import org.kitesdk.data.spi.LastModifiedAccessor;
import org.kitesdk.data.spi.Mergeable;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.data.spi.PartitionListener;
import org.kitesdk.data.spi.PartitionedDataset;
import org.kitesdk.data.spi.Replaceable;
import org.kitesdk.data.spi.SizeAccessor;
import org.kitesdk.data.spi.filesystem.FileSystemPartitionView;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.kitesdk.data.spi.filesystem.FileSystemView;
import org.kitesdk.data.spi.filesystem.FileSystemViewKeyInputFormat;
import org.kitesdk.data.spi.filesystem.PathConversion;
import org.kitesdk.data.spi.filesystem.PathFilters;
import org.kitesdk.data.spi.filesystem.PathIterator;
import org.kitesdk.data.spi.filesystem.SignalManager;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.Iterables;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileSystemDataset<E>
extends AbstractDataset<E>
implements Mergeable<FileSystemDataset<E>>,
InputFormatAccessor<E>,
LastModifiedAccessor,
PartitionedDataset<E>,
SizeAccessor,
Signalable<E>,
Replaceable<View<E>> {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemDataset.class);
    private final FileSystem fileSystem;
    private final Path directory;
    private final String namespace;
    private final String name;
    private final DatasetDescriptor descriptor;
    private PartitionKey partitionKey;
    private final URI uri;
    private static final String SIGNALS_DIRECTORY_NAME = ".signals";
    private final PartitionStrategy partitionStrategy;
    private final PartitionListener partitionListener;
    final FileSystemPartitionView<E> unbounded;
    private final PathConversion convert;
    private final SignalManager signalManager;

    FileSystemDataset(FileSystem fileSystem, Path directory, String namespace, String name, DatasetDescriptor descriptor, URI uri, @Nullable PartitionListener partitionListener, Class<E> type) {
        super(type, descriptor.getSchema());
        if (Formats.PARQUET.equals(descriptor.getFormat())) {
            Preconditions.checkArgument(IndexedRecord.class.isAssignableFrom(type) || type == Object.class, "Parquet only supports generic and specific data models, type parameter must implement IndexedRecord");
        }
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.namespace = namespace;
        this.name = name;
        this.descriptor = descriptor;
        this.partitionStrategy = descriptor.isPartitioned() ? descriptor.getPartitionStrategy() : null;
        this.partitionListener = partitionListener;
        this.convert = new PathConversion(descriptor.getSchema());
        this.uri = uri;
        Path signalsPath = new Path(FileSystemDataset.getDirectory(fileSystem, directory), SIGNALS_DIRECTORY_NAME);
        this.signalManager = new SignalManager(fileSystem, signalsPath);
        this.unbounded = new FileSystemPartitionView<E>(this, partitionListener, this.signalManager, type);
        this.partitionKey = null;
    }

    FileSystemDataset(FileSystem fileSystem, Path directory, String namespace, String name, DatasetDescriptor descriptor, URI uri, @Nullable PartitionKey partitionKey, @Nullable PartitionListener partitionListener, Class<E> type) {
        this(fileSystem, directory, namespace, name, descriptor, uri, partitionListener, type);
        this.partitionKey = partitionKey;
    }

    private FileSystemDataset(FileSystemDataset<?> toCopy, Class<E> type) {
        super(type, toCopy.descriptor.getSchema());
        this.fileSystem = toCopy.fileSystem;
        this.directory = toCopy.directory;
        this.namespace = toCopy.namespace;
        this.name = toCopy.name;
        this.descriptor = toCopy.descriptor;
        this.partitionStrategy = toCopy.partitionStrategy;
        this.partitionListener = toCopy.partitionListener;
        this.convert = toCopy.convert;
        this.uri = toCopy.uri;
        this.signalManager = toCopy.signalManager;
        this.unbounded = new FileSystemPartitionView<E>(this, this.partitionListener, this.signalManager, type);
        this.partitionKey = null;
    }

    @Override
    public <T> Dataset<T> asType(Class<T> type) {
        if (this.getType().equals(type)) {
            return this;
        }
        return new FileSystemDataset<T>(this, type);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatasetDescriptor getDescriptor() {
        return this.descriptor;
    }

    View<E> viewForUri(URI location) {
        Preconditions.checkNotNull(location, "Partition location cannot be null");
        FileSystemPartitionView<E> view = this.getPartitionView(location);
        if (view == this.unbounded) {
            return this;
        }
        return view;
    }

    FileSystemPartitionView<E> getPartitionView(URI location) {
        return FileSystemPartitionView.getPartition(this.unbounded, location);
    }

    FileSystemPartitionView<E> getPartitionView(Path location) {
        return FileSystemPartitionView.getPartition(this.unbounded, location);
    }

    @Override
    public Iterable<PartitionView<E>> getCoveringPartitions() {
        return this.unbounded.getCoveringPartitions();
    }

    PartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    FileSystem getFileSystem() {
        return this.fileSystem;
    }

    Path getDirectory() {
        return this.directory;
    }

    PartitionListener getPartitionListener() {
        return this.partitionListener;
    }

    @Override
    public boolean deleteAll() {
        return this.unbounded.deleteAllUnsafe();
    }

    public PathIterator pathIterator() {
        return this.unbounded.pathIterator();
    }

    public Iterator<Path> dirIterator() {
        return this.unbounded.dirIterator();
    }

    @Override
    protected RefinableView<E> asRefinableView() {
        return this.unbounded;
    }

    @Override
    public FileSystemView<E> filter(Constraints c) {
        return this.unbounded.filter(c);
    }

    @Override
    @Nullable
    public PartitionedDataset<E> getPartition(PartitionKey key, boolean allowCreate) {
        Path partitionDirectory;
        block4: {
            Preconditions.checkState(this.descriptor.isPartitioned(), "Attempt to get a partition on a non-partitioned dataset (name:%s)", this.name);
            LOG.debug("Loading partition for key {}, allowCreate:{}", new Object[]{key, allowCreate});
            partitionDirectory = this.fileSystem.makeQualified(this.toDirectoryName(this.directory, key));
            try {
                if (this.fileSystem.exists(partitionDirectory)) break block4;
                if (allowCreate) {
                    if (this.partitionListener != null) {
                        this.partitionListener.partitionAdded(this.namespace, this.name, this.toRelativeDirectory(key).toString());
                    }
                    this.fileSystem.mkdirs(partitionDirectory);
                    break block4;
                }
                return null;
            }
            catch (IOException e) {
                throw new DatasetIOException("Unable to locate or create dataset partition directory " + partitionDirectory, e);
            }
        }
        int partitionDepth = key.getLength();
        PartitionStrategy subpartitionStrategy = Accessor.getDefault().getSubpartitionStrategy(this.partitionStrategy, partitionDepth);
        return new Builder().namespace(this.namespace).name(this.name).fileSystem(this.fileSystem).uri(this.uri).descriptor(new DatasetDescriptor.Builder(this.descriptor).location(partitionDirectory).partitionStrategy(subpartitionStrategy).build()).type(this.type).partitionKey(key).partitionListener(this.partitionListener).build();
    }

    @Override
    public void dropPartition(PartitionKey key) {
        Preconditions.checkState(this.descriptor.isPartitioned(), "Attempt to drop a partition on a non-partitioned dataset (name:%s)", this.name);
        Preconditions.checkNotNull(key, "Partition key may not be null");
        LOG.debug("Dropping partition with key:{} dataset:{}", (Object)key, (Object)this.name);
        Path partitionDirectory = this.toDirectoryName(this.directory, key);
        try {
            if (!this.fileSystem.delete(partitionDirectory, true)) {
                throw new IOException("Partition directory " + partitionDirectory + " for key " + key + " does not exist");
            }
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to locate or drop dataset partition directory " + partitionDirectory, e);
        }
    }

    @Override
    public Iterable<PartitionedDataset<E>> getPartitions() {
        FileStatus[] fileStatuses;
        Preconditions.checkState(this.descriptor.isPartitioned(), "Attempt to get partitions on a non-partitioned dataset (name:%s)", this.name);
        ArrayList partitions = Lists.newArrayList();
        try {
            fileStatuses = this.fileSystem.listStatus(this.directory, PathFilters.notHidden());
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to list partition directory for directory " + this.directory, e);
        }
        for (FileStatus stat : fileStatuses) {
            Path p = this.fileSystem.makeQualified(stat.getPath());
            PartitionKey key = this.keyFromDirectory(p.getName());
            PartitionStrategy subPartitionStrategy = Accessor.getDefault().getSubpartitionStrategy(this.partitionStrategy, 1);
            Builder builder = new Builder().namespace(this.namespace).name(this.name).fileSystem(this.fileSystem).uri(this.uri).descriptor(new DatasetDescriptor.Builder(this.descriptor).location(p).partitionStrategy(subPartitionStrategy).build()).type(this.type).partitionKey(key).partitionListener(this.partitionListener);
            partitions.add(builder.build());
        }
        return partitions;
    }

    public void addExistingPartitions() {
        if (this.partitionListener != null && this.descriptor.isPartitioned()) {
            Iterator<Path> i = this.dirIterator();
            while (i.hasNext()) {
                Path partition = i.next();
                LOG.info("Adding partition {}", (Object)partition);
                this.partitionListener.partitionAdded(this.namespace, this.name, partition.toString());
            }
        }
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.name).add("descriptor", this.descriptor).add("directory", this.directory).add("dataDirectory", this.directory).add("partitionKey", this.partitionKey).toString();
    }

    @Override
    public void merge(FileSystemDataset<E> update) {
        DatasetDescriptor updateDescriptor = update.getDescriptor();
        Compatibility.checkCompatible(updateDescriptor, this.descriptor);
        for (PartitionView<E> src : update.getCoveringPartitions()) {
            if (src instanceof FileSystemPartitionView) {
                FileSystemPartitionView<E> dest;
                URI relative = ((FileSystemPartitionView)src).getRelativeLocation();
                FileSystemPartitionView<E> fileSystemPartitionView = dest = relative != null ? this.getPartitionView(relative) : this.unbounded;
                if (this.descriptor.isPartitioned() && this.partitionListener != null && relative != null) {
                    this.partitionListener.partitionAdded(this.namespace, this.name, relative.toString());
                }
                List<Pair<Path, Path>> staged = FileSystemUtil.stageMove(this.fileSystem, new Path(src.getLocation().toString()), new Path(dest.getLocation().toString()), "tmp");
                FileSystemUtil.finishMove(this.fileSystem, staged);
                continue;
            }
            throw new IllegalArgumentException("Incompatible PartitionView: " + src.getClass().getName());
        }
    }

    @Override
    public boolean canReplace(View<E> part) {
        if (part instanceof FileSystemView) {
            return this.equals(part.getDataset()) && ((FileSystemView)part).getConstraints().alignedWithBoundaries();
        }
        if (part instanceof FileSystemDataset) {
            return this.equals(part);
        }
        return false;
    }

    @Override
    public void replace(View<E> target, View<E> replacement) {
        DatasetDescriptor updateDescriptor = replacement.getDataset().getDescriptor();
        Compatibility.checkCompatible(updateDescriptor, this.descriptor);
        if (this.descriptor.isPartitioned()) {
            HashSet<PartitionView<E>> notReplaced = Sets.newHashSet(target.getCoveringPartitions());
            for (PartitionView<E> src : replacement.getCoveringPartitions()) {
                if (src instanceof FileSystemPartitionView) {
                    FileSystemPartitionView<E> dest = this.getPartitionView(((FileSystemPartitionView)src).getRelativeLocation());
                    ArrayList<Path> removals = Lists.newArrayList();
                    Iterable<PartitionView<E>> existingPartitions = dest.toConstraintsView().getCoveringPartitions();
                    for (PartitionView<E> partition : existingPartitions) {
                        FileSystemPartitionView toReplace = (FileSystemPartitionView)partition;
                        Path path = new Path(toReplace.getLocation().toString());
                        removals.add(path);
                        notReplaced.remove(toReplace);
                        if (this.partitionListener == null || !this.descriptor.isPartitioned()) continue;
                        this.partitionListener.partitionDeleted(this.namespace, this.name, toReplace.getRelativeLocation().toString());
                    }
                    FileSystemUtil.replace(this.fileSystem, this.directory, new Path(dest.getLocation().toString()), new Path(src.getLocation().toString()), removals);
                    if (this.partitionListener == null || !this.descriptor.isPartitioned()) continue;
                    this.partitionListener.partitionAdded(this.namespace, this.name, dest.getRelativeLocation().toString());
                    continue;
                }
                throw new IllegalArgumentException("Incompatible PartitionView: " + src.getClass().getName());
            }
            for (PartitionView<E> toRemove : notReplaced) {
                toRemove.deleteAll();
            }
        } else {
            PartitionView<E> srcPartition = Iterables.getOnlyElement(replacement.getCoveringPartitions());
            List<Pair<Path, Path>> staged = FileSystemUtil.stageMove(this.fileSystem, new Path(srcPartition.getLocation().toString()), new Path(this.unbounded.getLocation().toString()), "replace");
            this.deleteAll();
            FileSystemUtil.finishMove(this.fileSystem, staged);
        }
    }

    @Override
    public InputFormat<E, Void> getInputFormat(Configuration conf) {
        return new FileSystemViewKeyInputFormat(this, conf);
    }

    private Path toDirectoryName(@Nullable Path dir, PartitionKey key) {
        Path result = dir;
        for (int i = 0; i < key.getLength(); ++i) {
            FieldPartitioner fp = Accessor.getDefault().getFieldPartitioners(this.partitionStrategy).get(i);
            result = result != null ? new Path(result, PathConversion.dirnameForValue(fp, key.get(i))) : new Path(PathConversion.dirnameForValue(fp, key.get(i)));
        }
        return result;
    }

    private Path toRelativeDirectory(PartitionKey key) {
        return this.toDirectoryName(null, key);
    }

    private PartitionKey keyFromDirectory(String name) {
        FieldPartitioner fp = Accessor.getDefault().getFieldPartitioners(this.partitionStrategy).get(0);
        ArrayList<Object> values = Lists.newArrayList();
        if (this.partitionKey != null) {
            values.addAll(this.partitionKey.getValues());
        }
        values.add(this.convert.valueForDirname(fp, name));
        return new PartitionKey(values.toArray());
    }

    public PartitionKey keyFromDirectory(Path dir) {
        Path relDir = null;
        URI relUri = this.directory.toUri().relativize(dir.toUri());
        if (!relUri.toString().isEmpty()) {
            relDir = new Path(relUri);
            Preconditions.checkState(!relDir.equals((Object)dir), "Partition directory %s is not relative to dataset directory %s", dir, this.directory);
        }
        ArrayList<String> pathComponents = Lists.newArrayList();
        while (relDir != null && !relDir.getName().equals("")) {
            pathComponents.add(0, relDir.getName());
            relDir = relDir.getParent();
        }
        List<FieldPartitioner> fps = Accessor.getDefault().getFieldPartitioners(this.partitionStrategy);
        Preconditions.checkState(pathComponents.size() <= fps.size(), "Number of components in partition directory %s (%s) exceeds number of field partitioners %s", dir, pathComponents, this.partitionStrategy);
        ArrayList<Object> values = Lists.newArrayList();
        for (int i = 0; i < pathComponents.size(); ++i) {
            values.add(this.convert.valueForDirname(fps.get(i), (String)pathComponents.get(i)));
        }
        if (this.partitionKey != null) {
            values.addAll(0, this.partitionKey.getValues());
        }
        return new PartitionKey(values.toArray());
    }

    @Override
    public long getSize() {
        long size = 0L;
        Iterator<Path> i = this.dirIterator();
        while (i.hasNext()) {
            Path dir = i.next();
            try {
                for (FileStatus st : this.fileSystem.listStatus(dir)) {
                    size += st.getLen();
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot find size of " + dir, e);
            }
        }
        return size;
    }

    @Override
    public long getLastModified() {
        return this.unbounded.getLastModified();
    }

    @Override
    public boolean isEmpty() {
        return this.unbounded.isEmpty();
    }

    @Override
    public void signalReady() {
        this.unbounded.signalReady();
    }

    @Override
    public boolean isReady() {
        return this.unbounded.isReady();
    }

    private static Path getDirectory(FileSystem fs, Path path) {
        try {
            if (!fs.exists(path) || fs.isDirectory(path)) {
                return path;
            }
            return path.getParent();
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot access path: " + path, e);
        }
    }

    public static class Builder<E> {
        private Configuration conf;
        private FileSystem fileSystem;
        private Path directory;
        private String namespace;
        private String name;
        private DatasetDescriptor descriptor;
        private Class<E> type;
        private URI uri;
        private PartitionKey partitionKey;
        private PartitionListener partitionListener;

        public Builder<E> namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder<E> name(String name) {
            this.name = name;
            return this;
        }

        protected Builder<E> fileSystem(FileSystem fs) {
            this.fileSystem = fs;
            return this;
        }

        public Builder<E> configuration(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder<E> descriptor(DatasetDescriptor descriptor) {
            Preconditions.checkArgument(descriptor.getLocation() != null, "Dataset location cannot be null");
            this.descriptor = descriptor;
            return this;
        }

        public Builder<E> type(Class<E> type) {
            Preconditions.checkNotNull(type, "Type cannot be null");
            this.type = type;
            return this;
        }

        public Builder<E> uri(URI uri) {
            this.uri = uri;
            return this;
        }

        Builder<E> partitionKey(@Nullable PartitionKey partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        Builder<E> partitionListener(@Nullable PartitionListener partitionListener) {
            this.partitionListener = partitionListener;
            return this;
        }

        public FileSystemDataset<E> build() {
            Preconditions.checkState(this.namespace != null, "No namespace defined");
            Preconditions.checkState(this.name != null, "No dataset name defined");
            Preconditions.checkState(this.descriptor != null, "No dataset descriptor defined");
            Preconditions.checkState(this.conf != null || this.fileSystem != null, "Configuration or FileSystem must be set");
            Preconditions.checkState(this.type != null, "No type specified");
            this.directory = new Path(this.descriptor.getLocation().toString());
            if (this.fileSystem == null) {
                try {
                    this.fileSystem = this.directory.getFileSystem(this.conf);
                }
                catch (IOException ex) {
                    throw new DatasetIOException("Cannot access FileSystem", ex);
                }
            }
            Path absoluteDirectory = this.fileSystem.makeQualified(this.directory);
            return new FileSystemDataset<E>(this.fileSystem, absoluteDirectory, this.namespace, this.name, this.descriptor, this.uri, this.partitionKey, this.partitionListener, this.type);
        }
    }
}

