/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import au.com.bytecode.opencsv.CSVParser;
import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.spi.Compatibility;
import org.kitesdk.data.spi.filesystem.CSVProperties;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;
import org.kitesdk.shaded.com.google.common.base.CharMatcher;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.ImmutableSet;
import org.kitesdk.shaded.com.google.common.collect.Lists;

@Deprecated
public class CSVUtil {
    private static final Pattern LONG = Pattern.compile("\\d+");
    private static final Pattern DOUBLE = Pattern.compile("\\d*\\.\\d*[dD]?");
    private static final Pattern FLOAT = Pattern.compile("\\d*\\.\\d*[fF]?");
    private static final int DEFAULT_INFER_LINES = 25;
    private static final Set<String> NO_REQUIRED_FIELDS = ImmutableSet.of();
    private static final CharMatcher NON_PRINTABLE = CharMatcher.inRange(' ', '~').negate();

    public static CSVParser newParser(CSVProperties props) {
        return new CSVParser(props.delimiter.charAt(0), props.quote.charAt(0), props.escape.charAt(0), false, true);
    }

    public static CSVReader newReader(InputStream incoming, CSVProperties props) {
        return new CSVReader((Reader)new InputStreamReader(incoming, Charset.forName(props.charset)), props.delimiter.charAt(0), props.quote.charAt(0), props.escape.charAt(0), props.linesToSkip, false, true);
    }

    public static CSVWriter newWriter(OutputStream outgoing, CSVProperties props) {
        return new CSVWriter((Writer)new OutputStreamWriter(outgoing, Charset.forName(props.charset)), props.delimiter.charAt(0), props.quote.charAt(0), props.escape.charAt(0));
    }

    public static Schema inferNullableSchema(String name, InputStream incoming, CSVProperties props) throws IOException {
        return CSVUtil.inferSchemaInternal(name, incoming, props, NO_REQUIRED_FIELDS, true);
    }

    public static Schema inferNullableSchema(String name, InputStream incoming, CSVProperties props, Set<String> requiredFields) throws IOException {
        return CSVUtil.inferSchemaInternal(name, incoming, props, requiredFields, true);
    }

    public static Schema inferSchema(String name, InputStream incoming, CSVProperties props) throws IOException {
        return CSVUtil.inferSchemaInternal(name, incoming, props, NO_REQUIRED_FIELDS, false);
    }

    public static Schema inferSchema(String name, InputStream incoming, CSVProperties props, Set<String> requiredFields) throws IOException {
        return CSVUtil.inferSchemaInternal(name, incoming, props, requiredFields, false);
    }

    private static Schema inferSchemaInternal(String name, InputStream incoming, CSVProperties props, Set<String> requiredFields, boolean makeNullable) throws IOException {
        int i;
        String[] line;
        String[] header;
        CSVReader reader = CSVUtil.newReader(incoming, props);
        if (props.useHeader) {
            header = reader.readNext();
            line = reader.readNext();
            Preconditions.checkNotNull(line, "No content to infer schema");
        } else if (props.header != null) {
            header = CSVUtil.newParser(props).parseLine(props.header);
            line = reader.readNext();
            Preconditions.checkNotNull(line, "No content to infer schema");
        } else {
            line = reader.readNext();
            Preconditions.checkNotNull(line, "No content to infer schema");
            header = new String[line.length];
            for (int i2 = 0; i2 < line.length; ++i2) {
                header[i2] = "field_" + String.valueOf(i2);
            }
        }
        Schema.Type[] types = new Schema.Type[header.length];
        String[] values = new String[header.length];
        boolean[] nullable = new boolean[header.length];
        boolean[] empty = new boolean[header.length];
        for (int processed = 0; processed < 25 && line != null; ++processed) {
            for (i = 0; i < header.length; ++i) {
                if (i < line.length) {
                    if (types[i] == null) {
                        types[i] = CSVUtil.inferFieldType(line[i]);
                        if (types[i] != null) {
                            values[i] = line[i];
                        }
                    }
                    if (line[i] == null) {
                        nullable[i] = true;
                        continue;
                    }
                    if (!line[i].isEmpty()) continue;
                    empty[i] = true;
                    continue;
                }
                nullable[i] = true;
            }
            line = reader.readNext();
        }
        SchemaBuilder.FieldAssembler fieldAssembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)name).doc("Schema generated by Kite")).fields();
        for (i = 0; i < header.length; ++i) {
            boolean foundNull;
            if (header[i] == null) {
                throw new DatasetException("Bad header for field " + i + ": null");
            }
            String fieldName = header[i].trim();
            if (fieldName.isEmpty()) {
                throw new DatasetException("Bad header for field " + i + ": \"" + fieldName + "\"");
            }
            if (!Compatibility.isAvroCompatibleName(fieldName)) {
                throw new DatasetException("Bad header for field, should start with a character or _ and can contain only alphanumerics and _ " + i + ": \"" + fieldName + "\"");
            }
            boolean bl = foundNull = nullable[i] || empty[i] && types[i] != Schema.Type.STRING;
            if (requiredFields.contains(fieldName)) {
                if (foundNull) {
                    throw new DatasetException("Found null value for required field: " + fieldName + " (" + types[i] + ")");
                }
                fieldAssembler = ((SchemaBuilder.FieldBuilder)fieldAssembler.name(fieldName).doc("Type inferred from '" + CSVUtil.sample(values[i]) + "'")).type(CSVUtil.schema(types[i], false)).noDefault();
                continue;
            }
            SchemaBuilder.GenericDefault defaultBuilder = ((SchemaBuilder.FieldBuilder)fieldAssembler.name(fieldName).doc("Type inferred from '" + CSVUtil.sample(values[i]) + "'")).type(CSVUtil.schema(types[i], makeNullable || foundNull));
            fieldAssembler = makeNullable || foundNull ? defaultBuilder.withDefault(null) : defaultBuilder.noDefault();
        }
        return (Schema)fieldAssembler.endRecord();
    }

    @VisibleForTesting
    static String sample(@Nullable String value) {
        if (value != null) {
            return NON_PRINTABLE.replaceFrom(value.subSequence(0, Math.min(50, value.length())), '.');
        }
        return "null";
    }

    private static Schema schema(Schema.Type type, boolean makeNullable) {
        Schema schema = Schema.create((Schema.Type)(type == null ? Schema.Type.STRING : type));
        if (makeNullable || type == null) {
            schema = Schema.createUnion(Lists.newArrayList(Schema.create((Schema.Type)Schema.Type.NULL), schema));
        }
        return schema;
    }

    private static Schema.Type inferFieldType(String example) {
        if (example == null || example.isEmpty()) {
            return null;
        }
        if (LONG.matcher(example).matches()) {
            return Schema.Type.LONG;
        }
        if (DOUBLE.matcher(example).matches()) {
            return Schema.Type.DOUBLE;
        }
        if (FLOAT.matcher(example).matches()) {
            return Schema.Type.FLOAT;
        }
        return Schema.Type.STRING;
    }
}

