/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.spi.filesystem.CSVProperties;
import org.kitesdk.data.spi.filesystem.CSVUtil;
import org.kitesdk.data.spi.filesystem.FileSystemWriter;
import org.kitesdk.shaded.com.google.common.base.Preconditions;

class CSVAppender<E>
implements FileSystemWriter.FileAppender<E> {
    private final CSVProperties props;
    private final FileSystem fs;
    private final Path path;
    private final Schema schema;
    private FSDataOutputStream outgoing;
    private CSVWriter writer;

    public CSVAppender(FileSystem fs, Path path, DatasetDescriptor descriptor) {
        this.fs = fs;
        this.path = path;
        this.schema = descriptor.getSchema();
        Preconditions.checkState(this.schema.getType() == Schema.Type.RECORD, "Unsupported schema (not a record): {}", this.schema);
        this.props = CSVProperties.fromDescriptor(descriptor);
    }

    @Override
    public void open() throws IOException {
        this.outgoing = this.fs.create(this.path, true);
        this.writer = CSVUtil.newWriter((OutputStream)this.outgoing, this.props);
    }

    @Override
    public void append(E entity) throws IOException {
        this.writer.writeNext(this.shred(entity));
    }

    @Override
    public long pos() throws IOException {
        return this.outgoing.getPos();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.outgoing.close();
    }

    @Override
    public void cleanup() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
        Hadoop.FSDataOutputStream.hflush.invoke((Object)this.outgoing, new Object[0]);
    }

    @Override
    public void sync() throws IOException {
        this.flush();
        Hadoop.FSDataOutputStream.hsync.invoke((Object)this.outgoing, new Object[0]);
    }

    private String[] shred(E entity) {
        if (entity instanceof IndexedRecord) {
            return CSVAppender.shredIndexed((IndexedRecord)entity, this.schema);
        }
        return CSVAppender.shredReflect(entity, this.schema);
    }

    private static String[] shredIndexed(IndexedRecord entity, Schema schema) {
        List fields = schema.getFields();
        String[] values = new String[fields.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = CSVAppender.valueString(entity.get(i), ((Schema.Field)fields.get(i)).schema());
        }
        return values;
    }

    private static <E> String[] shredReflect(E entity, Schema schema) {
        ReflectData reflect = ReflectData.get();
        List fields = schema.getFields();
        String[] values = new String[fields.size()];
        for (int i = 0; i < values.length; ++i) {
            Schema.Field field = (Schema.Field)fields.get(i);
            values[i] = CSVAppender.valueString(reflect.getField(entity, field.name(), i), field.schema());
        }
        return values;
    }

    private static String valueString(Object value, Schema schema) {
        if (value == null || schema.getType() == Schema.Type.NULL) {
            return null;
        }
        switch (schema.getType()) {
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case INT: 
            case LONG: 
            case STRING: {
                return value.toString();
            }
            case ENUM: {
                return String.valueOf(schema.getEnumOrdinal(value.toString()));
            }
            case UNION: {
                int index = ReflectData.get().resolveUnion(schema, value);
                return CSVAppender.valueString(value, (Schema)schema.getTypes().get(index));
            }
        }
        throw new DatasetOperationException("Unsupported field type:" + schema.getType(), new Object[0]);
    }
}

