/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.kitesdk.data.DatasetOperationException;

abstract class AbstractCombineFileRecordReader<K, V>
extends RecordReader<K, V> {
    private int idx;
    private RecordReader<K, V> delegate;

    public AbstractCombineFileRecordReader(CombineFileSplit split, TaskAttemptContext context, Integer idx) {
        this.idx = idx;
    }

    abstract FileInputFormat<K, V> getInputFormat();

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.delegate != null) {
            this.delegate.close();
        }
        if (!(split instanceof CombineFileSplit)) {
            throw new DatasetOperationException("Split is not a CombineFileSplit: %s:%s", split.getClass().getCanonicalName(), split);
        }
        CombineFileSplit combineSplit = (CombineFileSplit)split;
        FileSplit fileSplit = new FileSplit(combineSplit.getPath(this.idx), combineSplit.getOffset(this.idx), combineSplit.getLength(this.idx), combineSplit.getLocations());
        this.delegate = this.getInputFormat().createRecordReader((InputSplit)fileSplit, context);
        this.delegate.initialize((InputSplit)fileSplit, context);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.delegate.nextKeyValue();
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        return (K)this.delegate.getCurrentKey();
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return (V)this.delegate.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.delegate.getProgress();
    }

    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
    }
}

