/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.kitesdk.shaded.com.google.common.base.CharMatcher;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Splitter;
import org.kitesdk.shaded.com.google.common.collect.ImmutableMap;
import org.kitesdk.shaded.com.google.common.collect.Iterators;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Maps;

@Deprecated
public class URIPattern {
    public static final String SCHEME = "uri:scheme";
    public static final String HOST = "auth:host";
    public static final String PORT = "auth:port";
    public static final String USERNAME = "auth:username";
    public static final String PASSWORD = "auth:password";
    private static final Splitter PATH_SPLITTER = Splitter.on('/');
    private static final Joiner PATH_JOINER = Joiner.on('/');
    private static final Splitter PATH_QUERY_SPLITTER = Splitter.on('?');
    private static final Splitter.MapSplitter QUERY_SPLITTER = Splitter.on('&').withKeyValueSeparator(Splitter.on('='));
    private static final Joiner.MapJoiner QUERY_JOINER = Joiner.on('&').withKeyValueSeparator("=");
    private static final CharMatcher USER_PASS_SEPARATOR = CharMatcher.is(':');
    private static final CharMatcher VAR_START = CharMatcher.anyOf(":*");
    private static final int UNSPECIFIED_PORT = -1;
    private URI pattern;
    private String patternPath;
    private Map<String, String> defaults;
    private Map<String, String> lastMatch;

    public URIPattern(URI uri) {
        this.pattern = uri;
        HashMap<String, String> accumulator = Maps.newHashMap();
        if (this.pattern.isOpaque()) {
            Iterator<String> pathQuery = PATH_QUERY_SPLITTER.split(this.pattern.getSchemeSpecificPart()).iterator();
            this.patternPath = Iterators.getNext(pathQuery, null);
            URIPattern.addQuery(Iterators.getNext(pathQuery, null), accumulator);
        } else {
            this.patternPath = this.pattern.getRawPath();
            URIPattern.addQuery(this.pattern.getRawQuery(), accumulator);
            URIPattern.addAuthority(this.pattern, accumulator);
        }
        if (this.pattern.getScheme() != null) {
            accumulator.put(SCHEME, this.pattern.getScheme());
        }
        this.defaults = ImmutableMap.copyOf(accumulator);
    }

    public URIPattern(String uri) {
        this(URI.create(uri));
    }

    public String getScheme() {
        return this.pattern.getScheme();
    }

    public String getPatternString() {
        return this.pattern.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URIPattern that = (URIPattern)o;
        return Objects.equal(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hashCode(this.pattern);
    }

    public URI construct(Map<String, String> options) {
        LinkedHashMap<String, String> uriData = Maps.newLinkedHashMap(options);
        try {
            String scheme = this.defaults.get(SCHEME);
            if (uriData.containsKey(SCHEME)) {
                scheme = (String)uriData.remove(SCHEME);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(scheme).append(":");
            if (!this.pattern.isOpaque()) {
                String auth;
                StringBuilder authBuilder = new StringBuilder();
                String user = URIPattern.constructUserInfo(uriData, this.defaults);
                String host = URIPattern.removeNonDefault(HOST, uriData, this.defaults);
                int port = URIPattern.constructPort(uriData, this.defaults);
                if (user != null) {
                    authBuilder.append(user).append("@");
                }
                if (host != null) {
                    authBuilder.append(host);
                }
                if (port >= 0) {
                    authBuilder.append(":").append(port);
                }
                if (!(auth = authBuilder.toString()).isEmpty()) {
                    builder.append("//").append(auth);
                }
            }
            builder.append(URIPattern.constructPath(uriData, this.patternPath));
            String query = URIPattern.constructQuery(uriData, this.defaults);
            if (query != null) {
                builder.append("?").append(query);
            }
            return new URI(builder.toString());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Could not build URI", ex);
        }
    }

    public boolean matches(URI uri) {
        return this.getMatch(uri) != null;
    }

    public boolean matches(String uri) throws URISyntaxException {
        return this.matches(new URI(uri));
    }

    public Map<String, String> getMatch(URI uri) {
        if (this.pattern.isAbsolute() ? !this.pattern.getScheme().equalsIgnoreCase(uri.getScheme()) : uri.getScheme() != null) {
            return null;
        }
        LinkedHashMap<String, String> result = Maps.newLinkedHashMap(this.defaults);
        if (this.pattern.isOpaque()) {
            if (!uri.isOpaque()) {
                return null;
            }
            Iterator<String> pathQuery = PATH_QUERY_SPLITTER.split(uri.getRawSchemeSpecificPart()).iterator();
            if (!URIPattern.addPath(this.patternPath, Iterators.getNext(pathQuery, null), result)) {
                return null;
            }
            URIPattern.addQuery(Iterators.getNext(pathQuery, null), result);
        } else if (!uri.isOpaque()) {
            URIPattern.addAuthority(uri, result);
            if (this.patternPath.isEmpty() && !uri.getRawPath().isEmpty()) {
                return null;
            }
            if (!URIPattern.addPath(this.patternPath, uri.getRawPath(), result)) {
                return null;
            }
            URIPattern.addQuery(uri.getRawQuery(), result);
        } else {
            return null;
        }
        if (!URIPattern.addComplexMatch(this.pattern.getFragment(), uri.getFragment(), result)) {
            return null;
        }
        this.lastMatch = result;
        return result;
    }

    public Map<String, String> getMatch(String uri) throws URISyntaxException {
        return this.getMatch(new URI(uri));
    }

    public Map<String, String> getLastMatch() {
        return this.lastMatch;
    }

    public String toString() {
        return Objects.toStringHelper(URIPattern.class).add("pattern", this.pattern).toString();
    }

    private static boolean addPath(String pattern, String path, Map<String, String> storage) {
        String patternPart;
        boolean matchedAfterGlob = false;
        boolean matchedBeforeGlob = false;
        LinkedList<String> patternParts = Lists.newLinkedList(PATH_SPLITTER.split(pattern));
        LinkedList<String> parts = Lists.newLinkedList(PATH_SPLITTER.split(path));
        if (parts.peekLast().isEmpty()) {
            if (!patternParts.peekLast().startsWith("*")) {
                parts.removeLast();
            }
            if (patternParts.peekLast().isEmpty()) {
                patternParts.removeLast();
            }
        }
        String globPattern = null;
        while (!patternParts.isEmpty()) {
            patternPart = patternParts.removeFirst();
            if (patternPart.startsWith("*")) {
                globPattern = patternPart;
                break;
            }
            if (parts.isEmpty() || !URIPattern.addComplexMatch(patternPart, parts.removeFirst(), storage)) {
                return false;
            }
            if (patternPart.isEmpty()) continue;
            matchedBeforeGlob = true;
        }
        while (!patternParts.isEmpty()) {
            patternPart = patternParts.removeLast();
            if (patternPart.startsWith("*")) {
                throw new RuntimeException("Cannot use multiple glob patterns");
            }
            if (parts.isEmpty() || !URIPattern.addComplexMatch(patternPart, parts.removeLast(), storage)) {
                return false;
            }
            matchedAfterGlob = true;
        }
        if (globPattern != null && !parts.isEmpty()) {
            String joined = PATH_JOINER.join(parts);
            if (!joined.isEmpty() || matchedAfterGlob || matchedBeforeGlob) {
                storage.put(globPattern.substring(1), joined);
            }
            return true;
        }
        return parts.isEmpty();
    }

    private static boolean addComplexMatch(String pattern, String part, Map<String, String> storage) {
        if (pattern == null) {
            return part == null;
        }
        if (pattern.isEmpty()) {
            return part.isEmpty();
        }
        return URIPattern.addSimpleMatch(pattern, part, storage);
    }

    private static boolean addSimpleMatch(String pattern, String part, Map<String, String> storage) {
        if (VAR_START.matches(pattern.charAt(0))) {
            storage.put(pattern.substring(1), part);
            return true;
        }
        return pattern.equals(part);
    }

    private static void addAuthority(URI uri, Map<String, String> storage) {
        String userInfo;
        if (uri.getHost() != null) {
            storage.put(HOST, uri.getHost());
        }
        if (uri.getPort() >= 0) {
            storage.put(PORT, String.valueOf(uri.getPort()));
        }
        if ((userInfo = uri.getUserInfo()) != null) {
            int index = USER_PASS_SEPARATOR.indexIn(userInfo);
            if (index > 0) {
                storage.put(USERNAME, userInfo.substring(0, index));
                storage.put(PASSWORD, userInfo.substring(index + 1));
            } else {
                storage.put(USERNAME, userInfo);
            }
        }
    }

    private static void addQuery(String query, Map<String, String> storage) {
        if (query != null) {
            storage.putAll(QUERY_SPLITTER.split(query));
        }
    }

    private static String removeNonDefault(String key, Map<String, String> options, Map<String, String> defaults) {
        String defaultValue = defaults.get(key);
        if (options.containsKey(key)) {
            String value = options.remove(key);
            if (defaultValue == null || !defaultValue.equals(value)) {
                return value;
            }
        }
        return null;
    }

    private static String constructQuery(Map<String, String> uriOptions, Map<String, String> defaults) {
        for (Map.Entry<String, String> entry : defaults.entrySet()) {
            String defaultValue;
            String key = entry.getKey();
            if (!uriOptions.containsKey(key) || (defaultValue = entry.getValue()) == null || !defaultValue.equals(uriOptions.get(key))) continue;
            uriOptions.remove(key);
        }
        if (uriOptions.isEmpty()) {
            return null;
        }
        return QUERY_JOINER.join(uriOptions);
    }

    private static String constructPath(Map<String, String> match, String pattern) {
        LinkedList<String> patternParts = Lists.newLinkedList(PATH_SPLITTER.split(pattern));
        ArrayList<String> pathParts = Lists.newArrayListWithExpectedSize(patternParts.size());
        for (String part : patternParts) {
            if (!part.isEmpty()) {
                if (VAR_START.matches(part.charAt(0))) {
                    String name = part.substring(1);
                    if (match.containsKey(name)) {
                        pathParts.add(match.remove(name));
                        continue;
                    }
                    if (part.startsWith("*")) continue;
                    throw new IllegalArgumentException("Missing required option: " + name);
                }
                pathParts.add(part);
                continue;
            }
            pathParts.add(part);
        }
        return PATH_JOINER.join(pathParts);
    }

    private static int constructPort(Map<String, String> uriOptions, Map<String, String> defaults) {
        String portStr = URIPattern.removeNonDefault(PORT, uriOptions, defaults);
        if (portStr != null) {
            try {
                return Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid port: " + portStr, e);
            }
        }
        return -1;
    }

    private static String constructUserInfo(Map<String, String> uriOptions, Map<String, String> defaults) {
        String username = URIPattern.removeNonDefault(USERNAME, uriOptions, defaults);
        String password = URIPattern.removeNonDefault(PASSWORD, uriOptions, defaults);
        if (username != null) {
            if (password != null) {
                return username + ":" + password;
            }
            return username;
        }
        return null;
    }
}

