/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.KeyRangeIterable;
import org.kitesdk.data.spi.Marker;
import org.kitesdk.data.spi.MarkerRange;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.partition.CalendarFieldPartitioner;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;
import org.kitesdk.shaded.com.google.common.base.Function;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.kitesdk.shaded.com.google.common.cache.CacheBuilder;
import org.kitesdk.shaded.com.google.common.cache.CacheLoader;
import org.kitesdk.shaded.com.google.common.cache.LoadingCache;
import org.kitesdk.shaded.com.google.common.collect.DiscreteDomains;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Maps;

@Deprecated
@Immutable
public class TimeDomain {
    private static final List<Integer> order = Lists.newArrayList(1, 2, 5, 11, 12, 13);
    private static final LoadingCache<Pair<PartitionStrategy, String>, TimeDomain> domains = CacheBuilder.newBuilder().build(new CacheLoader<Pair<PartitionStrategy, String>, TimeDomain>(){

        @Override
        public TimeDomain load(Pair<PartitionStrategy, String> entry) {
            return new TimeDomain(entry.first(), entry.second());
        }
    });
    private final List<CalendarFieldPartitioner> partitioners;

    public static TimeDomain get(PartitionStrategy strategy, String source) {
        return domains.getUnchecked(Pair.of(strategy, source));
    }

    public TimeDomain(PartitionStrategy strategy, String sourceName) {
        HashMap<Integer, CalendarFieldPartitioner> mapping = Maps.newHashMap();
        for (FieldPartitioner fp : Accessor.getDefault().getFieldPartitioners(strategy)) {
            if (!sourceName.equals(fp.getSourceName()) || !(fp instanceof CalendarFieldPartitioner)) continue;
            mapping.put(((CalendarFieldPartitioner)fp).getCalendarField(), (CalendarFieldPartitioner)fp);
        }
        this.partitioners = Lists.newArrayList();
        Iterator<Object> iterator = order.iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            if (mapping.containsKey(field)) {
                this.partitioners.add((CalendarFieldPartitioner)mapping.get(field));
                continue;
            }
            if (this.partitioners.isEmpty()) continue;
            break;
        }
    }

    public Predicate<Marker> project(Predicate<Long> predicate) {
        if (predicate instanceof In) {
            return new TimeSetPredicate((In)predicate);
        }
        if (predicate instanceof Range) {
            return new TimeRangePredicate((Range)predicate);
        }
        return null;
    }

    public Predicate<Marker> projectStrict(Predicate<Long> predicate) {
        if (predicate instanceof Exists) {
            return Predicates.exists();
        }
        if (predicate instanceof In) {
            return null;
        }
        if (predicate instanceof Range) {
            return new TimeRangeStrictPredicate((Range)predicate);
        }
        return null;
    }

    Iterator<MarkerRange.Builder> addStackedIterator(Predicate<Long> timePredicate, Iterator<MarkerRange.Builder> inner) {
        if (timePredicate instanceof In) {
            return new KeyRangeIterable.SetGroupIterator((In)timePredicate, this.partitioners, inner);
        }
        if (timePredicate instanceof Range) {
            return new TimeRangeIterator((Range)timePredicate, this.partitioners, inner);
        }
        return null;
    }

    private static class TimeRangeIterator
    extends KeyRangeIterable.StackedIterator<Range<Long>, MarkerRange.Builder> {
        private final List<CalendarFieldPartitioner> fields;

        private TimeRangeIterator(Range<Long> timeRange, List<CalendarFieldPartitioner> fps, Iterator<MarkerRange.Builder> inner) {
            this.fields = fps;
            this.setItem(timeRange);
            this.setInner(inner);
        }

        @Override
        public MarkerRange.Builder update(MarkerRange.Builder current, Range<Long> range) {
            for (CalendarFieldPartitioner cfp : this.fields) {
                boolean hasLower = range.hasLowerBound();
                boolean hasUpper = range.hasUpperBound();
                if (hasLower) {
                    current.addToStart(cfp.getName(), cfp.apply(range.lowerEndpoint()));
                }
                if (!hasUpper) continue;
                current.addToEnd(cfp.getName(), cfp.apply(range.upperEndpoint()));
            }
            return current;
        }
    }

    private class TimeRangePredicateImpl
    implements Predicate<Marker> {
        private final Range<Long> range;
        private final String[] names;
        private final int[] lower;
        private final int[] upper;
        private final boolean acceptEqual;

        private TimeRangePredicateImpl(Range<Long> timeRange, boolean acceptEqual) {
            int i;
            this.range = Ranges.adjustClosed(timeRange, DiscreteDomains.longs());
            this.acceptEqual = acceptEqual;
            int length = TimeDomain.this.partitioners.size();
            this.names = new String[length];
            for (int i2 = 0; i2 < length; ++i2) {
                this.names[i2] = ((CalendarFieldPartitioner)TimeDomain.this.partitioners.get(i2)).getName();
            }
            if (this.range.hasLowerBound()) {
                long start = this.range.lowerEndpoint() - (long)(acceptEqual ? 0 : 1);
                this.lower = new int[length];
                for (i = 0; i < length; ++i) {
                    this.lower[i] = ((CalendarFieldPartitioner)TimeDomain.this.partitioners.get(i)).apply(start);
                }
            } else {
                this.lower = new int[0];
            }
            if (this.range.hasUpperBound()) {
                long stop = this.range.upperEndpoint() + (long)(acceptEqual ? 0 : 1);
                this.upper = new int[length];
                for (i = 0; i < length; ++i) {
                    this.upper[i] = ((CalendarFieldPartitioner)TimeDomain.this.partitioners.get(i)).apply(stop);
                }
            } else {
                this.upper = new int[0];
            }
        }

        @Override
        public boolean apply(@Nullable Marker key) {
            if (key == null) {
                return false;
            }
            boolean returnVal = true;
            if (this.lower.length > 0) {
                returnVal = this.checkLower(key);
            }
            if (returnVal && this.upper.length > 0) {
                returnVal = this.checkUpper(key);
            }
            return returnVal;
        }

        private boolean checkLower(Marker key) {
            for (int i = 0; i < this.names.length; ++i) {
                int value = (Integer)key.get(this.names[i]);
                if (value < this.lower[i]) {
                    return false;
                }
                if (value <= this.lower[i]) continue;
                return true;
            }
            return this.acceptEqual;
        }

        private boolean checkUpper(Marker key) {
            for (int i = 0; i < this.names.length; ++i) {
                int value = (Integer)key.get(this.names[i]);
                if (value > this.upper[i]) {
                    return false;
                }
                if (value >= this.upper[i]) continue;
                return true;
            }
            return this.acceptEqual;
        }

        @Override
        public boolean equals(Object obj) {
            int i;
            boolean differ;
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof TimeRangePredicateImpl)) {
                return false;
            }
            TimeRangePredicateImpl that = (TimeRangePredicateImpl)obj;
            if (!this.range.equals(that.range)) {
                return false;
            }
            if (this.acceptEqual == that.acceptEqual) {
                return true;
            }
            if (this.lower.length > 0) {
                differ = false;
                for (i = 0; i < this.lower.length; ++i) {
                    if (this.lower[i] == that.lower[i]) continue;
                    differ = true;
                    break;
                }
                if (!differ) {
                    return false;
                }
            }
            if (this.upper.length > 0) {
                differ = false;
                for (i = 0; i < this.upper.length; ++i) {
                    if (this.upper[i] == that.upper[i]) continue;
                    differ = true;
                    break;
                }
                if (!differ) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(this.range, this.acceptEqual);
        }

        public String toString() {
            Objects.ToStringHelper helper = Objects.toStringHelper(this);
            if (this.lower.length > 0) {
                helper.add("lower", Arrays.toString(this.lower));
            }
            if (this.upper.length > 0) {
                helper.add("upper", Arrays.toString(this.upper));
            }
            return helper.toString();
        }
    }

    private class TimeRangeStrictPredicate
    extends TimeRangePredicateImpl {
        private TimeRangeStrictPredicate(Range<Long> timeRange) {
            super(timeRange, false);
        }
    }

    private class TimeRangePredicate
    extends TimeRangePredicateImpl {
        private TimeRangePredicate(Range<Long> timeRange) {
            super(timeRange, true);
        }
    }

    private class TimeSetPredicate
    implements Predicate<Marker> {
        private final In<List<Integer>> times;

        private TimeSetPredicate(In<Long> times) {
            this.times = times.transform(new Function<Long, List<Integer>>(){

                @Override
                public List<Integer> apply(@Nullable Long timestamp) {
                    ArrayList<Integer> time = Lists.newArrayListWithExpectedSize(TimeDomain.this.partitioners.size());
                    for (CalendarFieldPartitioner fp : TimeDomain.this.partitioners) {
                        time.add(fp.apply(timestamp));
                    }
                    return time;
                }
            });
        }

        @Override
        public boolean apply(@Nullable Marker key) {
            ArrayList<Integer> time = Lists.newArrayListWithExpectedSize(TimeDomain.this.partitioners.size());
            for (CalendarFieldPartitioner fp : TimeDomain.this.partitioners) {
                time.add((Integer)key.get(fp.getName()));
            }
            return this.times.apply(time);
        }

        public String toString() {
            return Objects.toStringHelper(this).add("in", this.times).toString();
        }
    }
}

