/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.JsonUtil;
import org.kitesdk.shaded.com.google.common.io.Closeables;
import org.kitesdk.shaded.com.google.common.io.Resources;

@Deprecated
public class Schemas {
    private static final String RESOURCE_URI_SCHEME = "resource";

    public static Schema fromAvsc(InputStream in) throws IOException {
        return new Schema.Parser().parse(in);
    }

    public static Schema fromAvsc(File location) throws IOException {
        return Schemas.fromAvsc((FileSystem)FileSystem.getLocal((Configuration)DefaultConfiguration.get()), new Path(location.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema fromAvsc(FileSystem fs, Path path) throws IOException {
        FSDataInputStream in = null;
        boolean threw = true;
        try {
            in = fs.open(path);
            Schema schema = new Schema.Parser().parse((InputStream)in);
            threw = false;
            Schema schema2 = schema;
            return schema2;
        }
        finally {
            Closeables.close((Closeable)in, threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema fromAvsc(Configuration conf, URI location) throws IOException {
        InputStream in = null;
        boolean threw = true;
        try {
            in = Schemas.open(conf, location);
            Schema schema = Schemas.fromAvsc(in);
            threw = false;
            Schema schema2 = schema;
            return schema2;
        }
        finally {
            Closeables.close(in, threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema fromAvro(InputStream in) throws IOException {
        Schema schema;
        GenericDatumReader datumReader = new GenericDatumReader();
        DataFileStream stream = null;
        boolean threw = true;
        try {
            stream = new DataFileStream(in, (DatumReader)datumReader);
            Schema schema2 = stream.getSchema();
            threw = false;
            schema = schema2;
        }
        catch (Throwable throwable) {
            Closeables.close(stream, threw);
            throw throwable;
        }
        Closeables.close((Closeable)stream, threw);
        return schema;
    }

    public static Schema fromAvro(File location) throws IOException {
        return Schemas.fromAvro((FileSystem)FileSystem.getLocal((Configuration)DefaultConfiguration.get()), new Path(location.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema fromAvro(FileSystem fs, Path location) throws IOException {
        FSDataInputStream in = null;
        boolean threw = true;
        try {
            in = fs.open(location);
            Schema schema = Schemas.fromAvro((InputStream)in);
            threw = false;
            Schema schema2 = schema;
            return schema2;
        }
        finally {
            Closeables.close((Closeable)in, threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema fromAvro(Configuration conf, URI location) throws IOException {
        InputStream in = null;
        boolean threw = true;
        try {
            in = Schemas.open(conf, location);
            Schema schema = Schemas.fromAvro(in);
            threw = false;
            Schema schema2 = schema;
            return schema2;
        }
        finally {
            Closeables.close(in, threw);
        }
    }

    public static Schema fromParquet(File location) throws IOException {
        return Schemas.fromParquet((FileSystem)FileSystem.getLocal((Configuration)DefaultConfiguration.get()), new Path(location.getPath()));
    }

    public static Schema fromParquet(FileSystem fs, Path location) throws IOException {
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)fs.getConf(), (Path)location);
        String schemaString = (String)footer.getFileMetaData().getKeyValueMetaData().get("parquet.avro.schema");
        if (schemaString == null) {
            schemaString = (String)footer.getFileMetaData().getKeyValueMetaData().get("avro.schema");
        }
        if (schemaString != null) {
            return new Schema.Parser().parse(schemaString);
        }
        return new AvroSchemaConverter().convert(footer.getFileMetaData().getSchema());
    }

    public static Schema fromParquet(Configuration conf, URI location) throws IOException {
        Path path = new Path(location);
        return Schemas.fromParquet(path.getFileSystem(conf), path);
    }

    public static Schema fromJSON(String name, InputStream in) throws IOException {
        return JsonUtil.inferSchema(in, name, 20);
    }

    public static Schema fromJSON(String name, File location) throws IOException {
        return Schemas.fromJSON(name, (FileSystem)FileSystem.getLocal((Configuration)DefaultConfiguration.get()), new Path(location.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema fromJSON(String name, FileSystem fs, Path location) throws IOException {
        FSDataInputStream in = null;
        boolean threw = true;
        try {
            in = fs.open(location);
            Schema schema = Schemas.fromJSON(name, (InputStream)in);
            threw = false;
            Schema schema2 = schema;
            return schema2;
        }
        finally {
            Closeables.close((Closeable)in, threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema fromJSON(String name, Configuration conf, URI location) throws IOException {
        InputStream in = null;
        boolean threw = true;
        try {
            in = Schemas.open(conf, location);
            Schema schema = Schemas.fromJSON(name, in);
            threw = false;
            Schema schema2 = schema;
            return schema2;
        }
        finally {
            Closeables.close(in, threw);
        }
    }

    private static InputStream open(Configuration conf, URI location) throws IOException {
        if (RESOURCE_URI_SCHEME.equals(location.getScheme())) {
            return Resources.getResource(location.getRawSchemeSpecificPart()).openStream();
        }
        Path path = new Path(location);
        return path.getFileSystem(conf).open(path);
    }
}

