/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.partition.IdentityFieldPartitioner;
import org.kitesdk.data.spi.partition.ProvidedFieldPartitioner;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Splitter;
import org.kitesdk.shaded.com.google.common.collect.ImmutableList;
import org.kitesdk.shaded.com.google.common.collect.ImmutableMap;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Sets;

@Deprecated
public class SchemaUtil {
    static final Splitter NAME_SPLITTER = Splitter.on('.');
    static final Joiner NAME_JOINER = Joiner.on('.');
    private static final ImmutableMap<Schema.Type, Class<?>> TYPE_TO_CLASS = ImmutableMap.builder().put(Schema.Type.BOOLEAN, Boolean.class).put(Schema.Type.INT, Integer.class).put(Schema.Type.LONG, Long.class).put(Schema.Type.FLOAT, Float.class).put(Schema.Type.DOUBLE, Double.class).put(Schema.Type.STRING, String.class).put(Schema.Type.BYTES, ByteBuffer.class).build();
    private static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final NullNode NULL_DEFAULT = NullNode.getInstance();
    private static float SIMILARITY_THRESH = 0.3f;

    public static Class<?> getClassForType(Schema.Type type) {
        return TYPE_TO_CLASS.get(type);
    }

    public static <S> Class<? extends S> getSourceType(FieldPartitioner<S, ?> fp, Schema schema) {
        return SchemaUtil.getClassForType(SchemaUtil.fieldSchema(schema, fp.getSourceName()).getType());
    }

    public static <S, T> Class<? extends T> getPartitionType(FieldPartitioner<S, T> fp, Schema schema) {
        if (fp instanceof ProvidedFieldPartitioner) {
            return fp.getType();
        }
        Class<?> inputType = SchemaUtil.getClassForType(SchemaUtil.fieldSchema(schema, fp.getSourceName()).getType());
        return fp.getType(inputType);
    }

    public static boolean isConsistentWithExpectedType(Schema.Type type, Class<?> expectedClass) {
        Class<?> typeClass = TYPE_TO_CLASS.get(type);
        return typeClass != null && expectedClass.isAssignableFrom(typeClass);
    }

    public static boolean isConsistentWithMappingType(Schema.Type type, FieldMapping.MappingType mappingType) {
        switch (mappingType) {
            case COUNTER: 
            case OCC_VERSION: {
                return type == Schema.Type.INT || type == Schema.Type.LONG;
            }
            case KEY_AS_COLUMN: {
                return type == Schema.Type.MAP || type == Schema.Type.RECORD;
            }
            case KEY: {
                return TYPE_TO_CLASS.containsKey(type);
            }
        }
        return true;
    }

    public static void checkTypeConsistency(Schema schema, String fieldName, Object ... values) {
        SchemaUtil.checkTypeConsistency(schema, null, fieldName, values);
    }

    public static void checkTypeConsistency(Schema schema, PartitionStrategy strategy, String fieldName, Object ... values) {
        Schema fieldSchema = SchemaUtil.fieldSchema(schema, strategy, fieldName);
        for (Object value : values) {
            Preconditions.checkArgument(SpecificData.get().validate(fieldSchema, value), "Value '%s' of type '%s' inconsistent with field schema %s.", value, value.getClass(), fieldSchema);
        }
    }

    public static Schema partitionFieldSchema(FieldPartitioner<?, ?> fp, Schema schema) {
        if (fp instanceof IdentityFieldPartitioner) {
            return SchemaUtil.fieldSchema(schema, fp.getSourceName());
        }
        Class<?> fieldType = SchemaUtil.getPartitionType(fp, schema);
        if (fieldType == Integer.class) {
            return Schema.create((Schema.Type)Schema.Type.INT);
        }
        if (fieldType == Long.class) {
            return Schema.create((Schema.Type)Schema.Type.LONG);
        }
        if (fieldType == String.class) {
            return Schema.create((Schema.Type)Schema.Type.STRING);
        }
        throw new ValidationException("Cannot encode partition " + fp.getName() + " with type " + fp.getSourceType());
    }

    public static boolean isField(Schema schema, PartitionStrategy strategy, String name) {
        Schema.Field field = schema.getField(name);
        return field != null || strategy != null && Accessor.getDefault().hasPartitioner(strategy, name);
    }

    public static Schema fieldSchema(Schema schema, PartitionStrategy strategy, String name) {
        if (strategy != null && Accessor.getDefault().hasPartitioner(strategy, name)) {
            return SchemaUtil.partitionFieldSchema(Accessor.getDefault().getPartitioner(strategy, name), schema);
        }
        Schema nested = SchemaUtil.fieldSchema(schema, name);
        if (nested != null) {
            return nested;
        }
        throw new IllegalArgumentException("Not a schema or partition field: " + name);
    }

    public static Schema fieldSchema(Schema schema, String name) {
        Schema nested = SchemaUtil.unwrapNullable(schema);
        ArrayList<String> levels = Lists.newArrayList();
        for (String level : NAME_SPLITTER.split(name)) {
            levels.add(level);
            ValidationException.check(Schema.Type.RECORD == schema.getType(), "Cannot get schema for %s: %s is not a record schema: %s", name, NAME_JOINER.join(levels), nested.toString(true));
            Schema.Field field = nested.getField(level);
            ValidationException.check(field != null, "Cannot get schema for %s: %s is not a field", name, NAME_JOINER.join(levels));
            nested = SchemaUtil.unwrapNullable(field.schema());
        }
        return nested;
    }

    private static Schema unwrapNullable(Schema schema) {
        if (schema.getType() == Schema.Type.UNION && schema.getTypes().size() == 2) {
            List types = schema.getTypes();
            if (((Schema)types.get(0)).getType() == Schema.Type.NULL) {
                return (Schema)types.get(1);
            }
            if (((Schema)types.get(1)).getType() == Schema.Type.NULL) {
                return (Schema)types.get(0);
            }
        }
        return schema;
    }

    public static Schema keySchema(Schema schema, PartitionStrategy strategy) {
        ArrayList<Schema.Field> partitionFields = new ArrayList<Schema.Field>();
        for (FieldPartitioner fp : Accessor.getDefault().getFieldPartitioners(strategy)) {
            partitionFields.add(SchemaUtil.partitionField(fp, schema));
        }
        Schema keySchema = Schema.createRecord((String)(schema.getName() + "KeySchema"), null, null, (boolean)false);
        keySchema.setFields(partitionFields);
        return keySchema;
    }

    private static Schema.Field partitionField(FieldPartitioner<?, ?> fp, Schema schema) {
        return new Schema.Field(fp.getName(), SchemaUtil.partitionFieldSchema(fp, schema), null, null);
    }

    public static void checkPartitionedBy(DatasetDescriptor descriptor, String fieldName) {
        Preconditions.checkArgument(descriptor.isPartitioned(), "Descriptor %s is not partitioned", descriptor);
        Preconditions.checkArgument(Accessor.getDefault().hasPartitioner(descriptor.getPartitionStrategy(), fieldName), "Descriptor %s is not partitioned by '%s'", descriptor, fieldName);
    }

    public static <T> T visit(Schema schema, SchemaVisitor<T> visitor) {
        switch (schema.getType()) {
            case RECORD: {
                String name = schema.getFullName();
                Preconditions.checkState(!visitor.recordLevels.contains(name), "Cannot process recursive Avro record %s", name);
                visitor.recordLevels.push(name);
                List fields = schema.getFields();
                ArrayList<String> names = Lists.newArrayListWithExpectedSize(fields.size());
                ArrayList<T> results = Lists.newArrayListWithExpectedSize(fields.size());
                for (Schema.Field field : schema.getFields()) {
                    names.add(field.name());
                    results.add(SchemaUtil.visit(field.schema(), visitor));
                }
                visitor.recordLevels.pop();
                return visitor.record(schema, names, results);
            }
            case UNION: {
                List types = schema.getTypes();
                ArrayList<T> options = Lists.newArrayListWithExpectedSize(types.size());
                for (Schema type : types) {
                    options.add(SchemaUtil.visit(type, visitor));
                }
                return visitor.union(schema, options);
            }
            case ARRAY: {
                return visitor.array(schema, SchemaUtil.visit(schema.getElementType(), visitor));
            }
            case MAP: {
                return visitor.map(schema, SchemaUtil.visit(schema.getValueType(), visitor));
            }
        }
        return visitor.primitive(schema);
    }

    public static String toString(Object value, Schema schema) {
        switch (schema.getType()) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return value.toString();
            }
            case STRING: {
                try {
                    return URLEncoder.encode(value.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new DatasetIOException("Failed to encode value: " + value, e);
                }
            }
        }
        DatumWriter writer = ReflectData.get().createDatumWriter(schema);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
        try {
            writer.write(value, (Encoder)encoder);
            encoder.flush();
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot encode Avro value", e);
        }
        return Base64.encodeBase64URLSafeString((byte[])out.toByteArray());
    }

    public static <T> T fromString(String value, Schema schema) {
        switch (schema.getType()) {
            case BOOLEAN: {
                return (T)Boolean.valueOf(value);
            }
            case INT: {
                return (T)Integer.valueOf(value);
            }
            case LONG: {
                return (T)Long.valueOf(value);
            }
            case FLOAT: {
                return (T)Float.valueOf(value);
            }
            case DOUBLE: {
                return (T)Double.valueOf(value);
            }
            case STRING: {
                try {
                    return (T)URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new DatasetIOException("Failed to decode value: " + value, e);
                }
            }
        }
        byte[] binary = Base64.decodeBase64((String)value);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(binary), null);
        DatumReader reader = ReflectData.get().createDatumReader(schema);
        try {
            return (T)reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot decode Avro value", e);
        }
    }

    public static Schema merge(Iterable<Schema> schemas) {
        Iterator<Schema> iter = schemas.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        Schema result = iter.next();
        while (iter.hasNext()) {
            result = SchemaUtil.merge(result, iter.next());
        }
        return result;
    }

    public static Schema mergeOrUnion(Iterable<Schema> schemas) {
        Iterator<Schema> iter = schemas.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        Schema result = iter.next();
        while (iter.hasNext()) {
            result = SchemaUtil.mergeOrUnion(result, iter.next());
        }
        return result;
    }

    public static Schema merge(Schema left, Schema right) {
        Schema merged = SchemaUtil.mergeOnly(left, right);
        IncompatibleSchemaException.check(merged != null, "Cannot merge %s and %s", left, right);
        return merged;
    }

    private static Schema mergeOrUnion(Schema left, Schema right) {
        Schema merged = SchemaUtil.mergeOnly(left, right);
        if (merged != null) {
            return merged;
        }
        return SchemaUtil.union(left, right);
    }

    private static Schema union(Schema left, Schema right) {
        if (left.getType() == Schema.Type.UNION) {
            if (right.getType() == Schema.Type.UNION) {
                Schema combined = left;
                for (Schema type : right.getTypes()) {
                    combined = SchemaUtil.union(combined, type);
                }
                return combined;
            }
            boolean notMerged = true;
            ArrayList<Object> types = Lists.newArrayList();
            Iterator schemas = left.getTypes().iterator();
            while (schemas.hasNext()) {
                Schema next = (Schema)schemas.next();
                Schema merged = SchemaUtil.mergeOnly(next, right);
                if (merged != null) {
                    types.add(merged);
                    notMerged = false;
                    break;
                }
                types.add(next);
            }
            while (schemas.hasNext()) {
                types.add(schemas.next());
            }
            if (notMerged) {
                types.add(right);
            }
            return Schema.createUnion(types);
        }
        if (right.getType() == Schema.Type.UNION) {
            return SchemaUtil.union(right, left);
        }
        return Schema.createUnion(ImmutableList.of(left, right));
    }

    private static Schema mergeOnly(Schema left, Schema right) {
        if (Objects.equal(left, right)) {
            return left;
        }
        switch (left.getType()) {
            case INT: {
                if (right.getType() != Schema.Type.LONG) break;
                return right;
            }
            case LONG: {
                if (right.getType() != Schema.Type.INT) break;
                return left;
            }
            case FLOAT: {
                if (right.getType() != Schema.Type.DOUBLE) break;
                return right;
            }
            case DOUBLE: {
                if (right.getType() != Schema.Type.FLOAT) break;
                return left;
            }
        }
        if (left.getType() != right.getType()) {
            return null;
        }
        switch (left.getType()) {
            case UNION: {
                return SchemaUtil.union(left, right);
            }
            case RECORD: {
                if (left.getName() == null && right.getName() == null && SchemaUtil.fieldSimilarity(left, right) < SIMILARITY_THRESH) {
                    return null;
                }
                if (!Objects.equal(left.getName(), right.getName())) {
                    return null;
                }
                Schema combinedRecord = Schema.createRecord((String)SchemaUtil.coalesce(left.getName(), right.getName()), (String)SchemaUtil.coalesce(left.getDoc(), right.getDoc()), (String)SchemaUtil.coalesce(left.getNamespace(), right.getNamespace()), (boolean)false);
                combinedRecord.setFields(SchemaUtil.mergeFields(left, right));
                return combinedRecord;
            }
            case MAP: {
                return Schema.createMap((Schema)SchemaUtil.mergeOrUnion(left.getValueType(), right.getValueType()));
            }
            case ARRAY: {
                return Schema.createArray((Schema)SchemaUtil.mergeOrUnion(left.getElementType(), right.getElementType()));
            }
            case ENUM: {
                if (!Objects.equal(left.getName(), right.getName())) {
                    return null;
                }
                LinkedHashSet symbols = Sets.newLinkedHashSet();
                symbols.addAll(left.getEnumSymbols());
                symbols.addAll(right.getEnumSymbols());
                return Schema.createEnum((String)left.getName(), (String)SchemaUtil.coalesce(left.getDoc(), right.getDoc()), (String)SchemaUtil.coalesce(left.getNamespace(), right.getNamespace()), ImmutableList.copyOf(symbols));
            }
        }
        throw new UnsupportedOperationException("Unknown schema type: " + left.getType());
    }

    private static Schema nullableForDefault(Schema schema) {
        if (schema.getType() == Schema.Type.NULL) {
            return schema;
        }
        if (schema.getType() != Schema.Type.UNION) {
            return Schema.createUnion(ImmutableList.of(NULL, schema));
        }
        if (((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
            return schema;
        }
        ArrayList<Schema> types = Lists.newArrayList();
        types.add(NULL);
        for (Schema type : schema.getTypes()) {
            if (type.getType() == Schema.Type.NULL) continue;
            types.add(type);
        }
        return Schema.createUnion(types);
    }

    private static List<Schema.Field> mergeFields(Schema left, Schema right) {
        ArrayList<Schema.Field> fields = Lists.newArrayList();
        for (Schema.Field leftField : left.getFields()) {
            Schema.Field rightField = right.getField(leftField.name());
            if (rightField != null) {
                fields.add(new Schema.Field(leftField.name(), SchemaUtil.mergeOrUnion(leftField.schema(), rightField.schema()), SchemaUtil.coalesce(leftField.doc(), rightField.doc()), SchemaUtil.coalesce(leftField.defaultValue(), rightField.defaultValue())));
                continue;
            }
            if (leftField.defaultValue() != null) {
                fields.add(SchemaUtil.copy(leftField));
                continue;
            }
            fields.add(new Schema.Field(leftField.name(), SchemaUtil.nullableForDefault(leftField.schema()), leftField.doc(), (JsonNode)NULL_DEFAULT));
        }
        for (Schema.Field rightField : right.getFields()) {
            if (left.getField(rightField.name()) != null) continue;
            if (rightField.defaultValue() != null) {
                fields.add(SchemaUtil.copy(rightField));
                continue;
            }
            fields.add(new Schema.Field(rightField.name(), SchemaUtil.nullableForDefault(rightField.schema()), rightField.doc(), (JsonNode)NULL_DEFAULT));
        }
        return fields;
    }

    public static Schema.Field copy(Schema.Field field) {
        return new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue());
    }

    private static float fieldSimilarity(Schema left, Schema right) {
        Set<String> leftNames = SchemaUtil.names(left.getFields());
        Set<String> rightNames = SchemaUtil.names(right.getFields());
        int common = Sets.intersection(leftNames, rightNames).size();
        float leftRatio = (float)common / (float)leftNames.size();
        float rightRatio = (float)common / (float)rightNames.size();
        return SchemaUtil.hmean(leftRatio, rightRatio);
    }

    private static Set<String> names(Collection<Schema.Field> fields) {
        HashSet<String> names = Sets.newHashSet();
        for (Schema.Field field : fields) {
            names.add(field.name());
        }
        return names;
    }

    private static float hmean(float left, float right) {
        return 2.0f * left * right / (left + right);
    }

    private static <E> E coalesce(E ... objects) {
        for (E object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static boolean nullOk(Schema schema) {
        if (Schema.Type.NULL == schema.getType()) {
            return true;
        }
        if (Schema.Type.UNION == schema.getType()) {
            for (Schema possible : schema.getTypes()) {
                if (!SchemaUtil.nullOk(possible)) continue;
                return true;
            }
        }
        return false;
    }

    public static abstract class SchemaVisitor<T> {
        protected LinkedList<String> recordLevels = Lists.newLinkedList();

        public T record(Schema record, List<String> names, List<T> fields) {
            return null;
        }

        public T union(Schema union, List<T> options) {
            return null;
        }

        public T array(Schema array, T element) {
            return null;
        }

        public T map(Schema map, T value) {
            return null;
        }

        public T primitive(Schema primitive) {
            return null;
        }
    }
}

