/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.AccessorImpl;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.PartitionStrategyParser;
import org.kitesdk.data.spi.partition.DayOfMonthFieldPartitioner;
import org.kitesdk.data.spi.partition.HashFieldPartitioner;
import org.kitesdk.data.spi.partition.HourFieldPartitioner;
import org.kitesdk.data.spi.partition.IdentityFieldPartitioner;
import org.kitesdk.data.spi.partition.IntRangeFieldPartitioner;
import org.kitesdk.data.spi.partition.LongFixedSizeRangeFieldPartitioner;
import org.kitesdk.data.spi.partition.MinuteFieldPartitioner;
import org.kitesdk.data.spi.partition.MonthFieldPartitioner;
import org.kitesdk.data.spi.partition.PartitionFunctions;
import org.kitesdk.data.spi.partition.RangeFieldPartitioner;
import org.kitesdk.data.spi.partition.YearFieldPartitioner;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.collect.ImmutableList;
import org.kitesdk.shaded.com.google.common.collect.ImmutableMap;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Immutable
public class PartitionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionStrategy.class);
    private final List<FieldPartitioner> fieldPartitioners;
    private final Map<String, FieldPartitioner> partitionerMap;

    PartitionStrategy(List<FieldPartitioner> partitioners) {
        this.fieldPartitioners = ImmutableList.copyOf(partitioners);
        ImmutableMap.Builder<String, FieldPartitioner> mapBuilder = ImmutableMap.builder();
        for (FieldPartitioner fp : partitioners) {
            mapBuilder.put(fp.getName(), fp);
        }
        this.partitionerMap = mapBuilder.build();
    }

    List<FieldPartitioner> getFieldPartitioners() {
        return this.fieldPartitioners;
    }

    FieldPartitioner getPartitioner(String name) {
        return this.partitionerMap.get(name);
    }

    boolean hasPartitioner(String name) {
        return this.partitionerMap.containsKey(name);
    }

    public int getCardinality() {
        int cardinality = 1;
        for (FieldPartitioner fieldPartitioner : this.fieldPartitioners) {
            if (fieldPartitioner.getCardinality() == -1) {
                return -1;
            }
            cardinality *= fieldPartitioner.getCardinality();
        }
        return cardinality;
    }

    PartitionStrategy getSubpartitionStrategy(int startIndex) {
        if (startIndex == 0) {
            return this;
        }
        if (startIndex >= this.fieldPartitioners.size()) {
            return null;
        }
        return new PartitionStrategy(this.fieldPartitioners.subList(startIndex, this.fieldPartitioners.size()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        PartitionStrategy that = (PartitionStrategy)o;
        return Objects.equal(this.fieldPartitioners, that.fieldPartitioners);
    }

    public int hashCode() {
        return Objects.hashCode(this.fieldPartitioners);
    }

    public String toString() {
        return PartitionStrategyParser.toString(this, false);
    }

    public String toString(boolean pretty) {
        return PartitionStrategyParser.toString(this, pretty);
    }

    static {
        Accessor.setDefault(new AccessorImpl());
    }

    public static class Builder {
        private final List<FieldPartitioner> fieldPartitioners = Lists.newArrayList();
        private final Set<String> names = Sets.newHashSet();

        public Builder hash(String sourceName, int buckets) {
            this.add(new HashFieldPartitioner(sourceName, buckets));
            return this;
        }

        public Builder hash(String sourceName, @Nullable String name, int buckets) {
            this.add(new HashFieldPartitioner(sourceName, name, buckets));
            return this;
        }

        public Builder identity(String sourceName) {
            this.add(new IdentityFieldPartitioner<Object>(sourceName, Object.class));
            return this;
        }

        public Builder identity(String sourceName, String name) {
            this.add(new IdentityFieldPartitioner<Object>(sourceName, name, Object.class));
            return this;
        }

        public Builder identity(String sourceName, int cardinalityHint) {
            this.add(new IdentityFieldPartitioner<Object>(sourceName, Object.class, cardinalityHint));
            return this;
        }

        public Builder identity(String sourceName, String name, int cardinalityHint) {
            this.add(new IdentityFieldPartitioner<Object>(sourceName, name, Object.class, cardinalityHint));
            return this;
        }

        public Builder range(String sourceName, int ... upperBounds) {
            this.add(new IntRangeFieldPartitioner(sourceName, upperBounds));
            return this;
        }

        public Builder range(String sourceName, String ... upperBounds) {
            this.add(new RangeFieldPartitioner(sourceName, upperBounds));
            return this;
        }

        public Builder fixedSizeRange(String sourceName, long size) {
            this.add(new LongFixedSizeRangeFieldPartitioner(sourceName, size));
            return this;
        }

        public Builder fixedSizeRange(String sourceName, @Nullable String name, long size) {
            this.add(new LongFixedSizeRangeFieldPartitioner(sourceName, name, size));
            return this;
        }

        public Builder year(String sourceName, @Nullable String name) {
            this.add(new YearFieldPartitioner(sourceName, name));
            return this;
        }

        public Builder year(String sourceName) {
            this.add(new YearFieldPartitioner(sourceName));
            return this;
        }

        public Builder month(String sourceName, @Nullable String name) {
            this.add(new MonthFieldPartitioner(sourceName, name));
            return this;
        }

        public Builder month(String sourceName) {
            this.add(new MonthFieldPartitioner(sourceName));
            return this;
        }

        public Builder day(String sourceName, @Nullable String name) {
            this.add(new DayOfMonthFieldPartitioner(sourceName, name));
            return this;
        }

        public Builder day(String sourceName) {
            this.add(new DayOfMonthFieldPartitioner(sourceName));
            return this;
        }

        public Builder hour(String sourceName, @Nullable String name) {
            this.add(new HourFieldPartitioner(sourceName, name));
            return this;
        }

        public Builder hour(String sourceName) {
            this.add(new HourFieldPartitioner(sourceName));
            return this;
        }

        public Builder minute(String sourceName, @Nullable String name) {
            this.add(new MinuteFieldPartitioner(sourceName, name));
            return this;
        }

        public Builder minute(String sourceName) {
            this.add(new MinuteFieldPartitioner(sourceName));
            return this;
        }

        public Builder dateFormat(String sourceName, String name, String format) {
            this.add(PartitionFunctions.dateFormat(sourceName, name, format));
            return this;
        }

        public Builder provided(String name) {
            this.add(PartitionFunctions.provided(name, null));
            return this;
        }

        public Builder provided(String name, @Nullable String valuesType) {
            this.add(PartitionFunctions.provided(name, valuesType));
            return this;
        }

        public PartitionStrategy build() {
            return new PartitionStrategy(this.fieldPartitioners);
        }

        private void add(FieldPartitioner fp) {
            ValidationException.check(!this.names.contains(fp.getName()), "Partition name %s conflicts with an existing field or partition name", fp.getName());
            this.fieldPartitioners.add(fp);
            this.names.add(fp.getName());
        }
    }
}

