/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.RandomAccessDataset;
import org.kitesdk.data.spi.Conversions;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.kitesdk.shaded.com.google.common.collect.Maps;
import org.kitesdk.shaded.com.google.common.collect.Sets;

@Deprecated
public class Key {
    private final List<Object> values;

    Key(List<Object> values) {
        this.values = values;
    }

    public Object get(int index) {
        return this.values.get(index);
    }

    public int hashCode() {
        return Objects.hashCode(this.values);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Key) {
            return Objects.equal(this.values, ((Key)obj).values);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("values", this.values).toString();
    }

    public static class Builder {
        private Schema schema;
        private PartitionStrategy strategy;
        private Set<String> fieldNames;
        private final Map<String, Object> values;

        public Builder(RandomAccessDataset dataset) {
            this.schema = dataset.getDescriptor().getSchema();
            this.strategy = dataset.getDescriptor().getPartitionStrategy();
            this.fieldNames = Sets.newHashSet();
            for (FieldPartitioner fp : this.strategy.getFieldPartitioners()) {
                this.fieldNames.add(fp.getSourceName());
                this.fieldNames.add(fp.getName());
            }
            this.values = Maps.newHashMap();
        }

        public Builder add(String name, Object value) {
            Preconditions.checkArgument(this.fieldNames.contains(name), "Field %s not in schema.", name);
            this.values.put(name, value);
            return this;
        }

        public Key build() {
            List<FieldPartitioner> partitioners = this.strategy.getFieldPartitioners();
            ArrayList<Object> content = Lists.newArrayListWithCapacity(partitioners.size());
            for (FieldPartitioner fp : partitioners) {
                content.add(this.valueFor(fp));
            }
            return new Key(content);
        }

        private <S, T> T valueFor(FieldPartitioner<S, T> fp) {
            if (this.values.containsKey(fp.getName())) {
                return Conversions.convert(this.values.get(fp.getName()), SchemaUtil.getPartitionType(fp, this.schema));
            }
            if (this.values.containsKey(fp.getSourceName())) {
                return fp.apply(Conversions.convert(this.values.get(fp.getSourceName()), SchemaUtil.getSourceType(fp, this.schema)));
            }
            throw new IllegalStateException("Cannot create Key, missing data for field:" + fp.getName());
        }
    }
}

