/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.AbstractDataset;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.Lists;

@Deprecated
public class Datasets {
    public static <E, V extends View<E>> V load(URI uri, Class<E> type) {
        boolean isView = "view".equals(uri.getScheme());
        Preconditions.checkArgument(isView || "dataset".equals(uri.getScheme()), "Not a dataset or view URI: " + uri);
        Preconditions.checkNotNull(type, "The entity type can't be null, use Object.class to have the type determined by the schema.");
        Pair<DatasetRepository, Map<String, String>> pair = Registration.lookupDatasetUri(URI.create(uri.getRawSchemeSpecificPart()));
        DatasetRepository repo = pair.first();
        Map<String, String> uriOptions = pair.second();
        Dataset<E> dataset = repo.load(uriOptions.get("namespace"), uriOptions.get("dataset"), type);
        if (isView) {
            return Datasets.view(dataset, uriOptions);
        }
        return (V)dataset;
    }

    public static <V extends View<GenericRecord>> V load(URI uri) {
        return Datasets.load(uri, GenericRecord.class);
    }

    public static <E, V extends View<E>> V load(String uriString, Class<E> type) {
        return Datasets.load(URI.create(uriString), type);
    }

    public static <V extends View<GenericRecord>> V load(String uriString) {
        return Datasets.load(uriString, GenericRecord.class);
    }

    public static <E, V extends View<E>> V create(URI uri, DatasetDescriptor descriptor, Class<E> type) {
        boolean isView = "view".equals(uri.getScheme());
        Preconditions.checkArgument(isView || "dataset".equals(uri.getScheme()), "Not a dataset or view URI: " + uri);
        Preconditions.checkNotNull(type, "The entity type can't be null, use Object.class to have the type determined by the schema.");
        Pair<DatasetRepository, Map<String, String>> pair = Registration.lookupDatasetUri(URI.create(uri.getRawSchemeSpecificPart()));
        DatasetRepository repo = pair.first();
        Map<String, String> uriOptions = pair.second();
        if (descriptor.getLocation() == null && uriOptions.containsKey("location")) {
            descriptor = new DatasetDescriptor.Builder(descriptor).location(uriOptions.get("location")).build();
        }
        Dataset<E> dataset = repo.create(uriOptions.get("namespace"), uriOptions.get("dataset"), descriptor, type);
        if (isView) {
            return Datasets.view(dataset, uriOptions);
        }
        return (V)dataset;
    }

    public static <V extends View<GenericRecord>> V create(URI uri, DatasetDescriptor descriptor) {
        return Datasets.create(uri, descriptor, GenericRecord.class);
    }

    public static <E, V extends View<E>> V create(String uri, DatasetDescriptor descriptor, Class<E> type) {
        return Datasets.create(URI.create(uri), descriptor, type);
    }

    public static <V extends View<GenericRecord>> V create(String uri, DatasetDescriptor descriptor) {
        return Datasets.create(uri, descriptor, GenericRecord.class);
    }

    public static <E, D extends Dataset<E>> D update(URI uri, DatasetDescriptor descriptor, Class<E> type) {
        Preconditions.checkArgument("dataset".equals(uri.getScheme()), "Not a dataset or view URI: " + uri);
        Preconditions.checkNotNull(type, "The entity type can't be null, use Object.class to have the type determined by the schema.");
        Pair<DatasetRepository, Map<String, String>> pair = Registration.lookupDatasetUri(URI.create(uri.getRawSchemeSpecificPart()));
        DatasetRepository repo = pair.first();
        Map<String, String> uriOptions = pair.second();
        return (D)repo.update(uriOptions.get("namespace"), uriOptions.get("dataset"), descriptor, type);
    }

    public static <D extends Dataset<GenericRecord>> D update(URI uri, DatasetDescriptor descriptor) {
        return Datasets.update(uri, descriptor, GenericRecord.class);
    }

    public static <E, D extends Dataset<E>> D update(String uri, DatasetDescriptor descriptor, Class<E> type) {
        return Datasets.update(URI.create(uri), descriptor, type);
    }

    public static <D extends Dataset<GenericRecord>> D update(String uri, DatasetDescriptor descriptor) {
        return Datasets.update(uri, descriptor, GenericRecord.class);
    }

    public static boolean delete(URI uri) {
        Preconditions.checkArgument("dataset".equals(uri.getScheme()), "Not a dataset URI: " + uri);
        Pair<DatasetRepository, Map<String, String>> pair = Registration.lookupDatasetUri(URI.create(uri.getRawSchemeSpecificPart()));
        DatasetRepository repo = pair.first();
        Map<String, String> uriOptions = pair.second();
        return repo.delete(uriOptions.get("namespace"), uriOptions.get("dataset"));
    }

    public static boolean delete(String uri) {
        return Datasets.delete(URI.create(uri));
    }

    public static boolean exists(URI uri) {
        Preconditions.checkArgument("dataset".equals(uri.getScheme()), "Not a dataset URI: " + uri);
        Pair<DatasetRepository, Map<String, String>> pair = Registration.lookupDatasetUri(URI.create(uri.getRawSchemeSpecificPart()));
        DatasetRepository repo = pair.first();
        Map<String, String> uriOptions = pair.second();
        return repo.exists(uriOptions.get("namespace"), uriOptions.get("dataset"));
    }

    public static boolean exists(String uri) {
        return Datasets.exists(URI.create(uri));
    }

    public static Collection<URI> list(URI uri) {
        boolean isRepo = "repo".equals(uri.getScheme());
        Preconditions.checkArgument(isRepo, "Not a repository URI: " + uri);
        Object repo = Registration.open(URI.create(uri.getRawSchemeSpecificPart()));
        URI repoUri = repo.getUri();
        ArrayList<URI> datasets = Lists.newArrayList();
        for (String namespace : repo.namespaces()) {
            for (String dataset : repo.datasets(namespace)) {
                datasets.add(new URIBuilder(repoUri, namespace, dataset).build());
            }
        }
        return datasets;
    }

    public static Collection<URI> list(String uri) {
        return Datasets.list(URI.create(uri));
    }

    private static <E, V extends View<E>> V view(Dataset<E> dataset, Map<String, String> uriOptions) {
        if (dataset instanceof AbstractDataset) {
            DatasetDescriptor descriptor = dataset.getDescriptor();
            Schema schema = descriptor.getSchema();
            PartitionStrategy strategy = null;
            if (descriptor.isPartitioned()) {
                strategy = descriptor.getPartitionStrategy();
            }
            Constraints constraints = Constraints.fromQueryMap(schema, strategy, uriOptions);
            return (V)((AbstractDataset)dataset).filter(constraints);
        }
        return (V)dataset;
    }
}

