/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util.schema;

import com.google.common.base.Optional;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

public class URIUtil {
    public static URI removeFragment(URI id) {
        return URI.create(StringUtils.substringBefore((String)id.toString(), (String)"#"));
    }

    public static URI removeFile(URI id) {
        return URI.create(StringUtils.substringBeforeLast((String)id.toString(), (String)"/"));
    }

    public static Optional<URI> safeResolve(URI absolute, String relativePart) {
        if (!absolute.isAbsolute()) {
            return Optional.absent();
        }
        try {
            return Optional.of((Object)absolute.resolve(relativePart));
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }
}

