/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaUtil.class);
    private static final JsonNodeFactory NODE_FACTORY = JsonNodeFactory.instance;
    public static final String ILLEGAL_CHARACTER_REGEX = "[^0-9a-zA-Z_$]";

    public static String childQualifiedName(String parentQualifiedName, String childSimpleName) {
        String safeChildName = childSimpleName.replaceAll(ILLEGAL_CHARACTER_REGEX, "_");
        return StringUtils.isEmpty((CharSequence)parentQualifiedName) ? safeChildName : parentQualifiedName + "." + safeChildName;
    }

    public static ObjectNode readSchema(URL schemaUrl) {
        ObjectNode schemaNode = NODE_FACTORY.objectNode();
        schemaNode.put("$ref", schemaUrl.toString());
        return schemaNode;
    }

    public static ObjectNode mergeProperties(ObjectNode content, ObjectNode parent) {
        ObjectNode merged = parent.deepCopy();
        Iterator fields = content.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String fieldId = (String)field.getKey();
            merged.put(fieldId, ((JsonNode)field.getValue()).deepCopy());
        }
        return merged;
    }
}

