/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.streams.util.schema.Schema;
import org.apache.streams.util.schema.SchemaStore;
import org.apache.streams.util.schema.SchemaUtil;
import org.apache.streams.util.schema.URIUtil;
import org.jsonschema2pojo.ContentResolver;
import org.jsonschema2pojo.FragmentResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaStoreImpl
extends Ordering<Schema>
implements SchemaStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaStore.class);
    private static final JsonNodeFactory NODE_FACTORY = JsonNodeFactory.instance;
    protected Map<URI, Schema> schemas = new HashMap<URI, Schema>();
    protected FragmentResolver fragmentResolver = new FragmentResolver();
    protected ContentResolver contentResolver = new ContentResolver();

    @Override
    public synchronized Schema create(URI uri) {
        if (!this.getByUri(uri).isPresent()) {
            URI baseURI = URIUtil.removeFragment(uri);
            JsonNode baseNode = this.contentResolver.resolve(baseURI);
            if (uri.toString().contains("#") && !uri.toString().endsWith("#")) {
                Schema newSchema = new Schema(baseURI, baseNode, null, true);
                this.schemas.put(baseURI, newSchema);
                JsonNode childContent = this.fragmentResolver.resolve(baseNode, '#' + StringUtils.substringAfter((String)uri.toString(), (String)"#"));
                this.schemas.put(uri, new Schema(uri, childContent, newSchema, false));
            } else if (baseNode.has("extends") && baseNode.get("extends").isObject()) {
                URI ref = URI.create(((ObjectNode)baseNode.get("extends")).get("$ref").asText());
                URI absoluteURI = ref.isAbsolute() ? ref : baseURI.resolve(ref);
                JsonNode parentNode = this.contentResolver.resolve(absoluteURI);
                Schema parentSchema = null;
                parentSchema = this.schemas.get(absoluteURI) != null ? this.schemas.get(absoluteURI) : this.create(absoluteURI);
                this.schemas.put(uri, new Schema(uri, baseNode, parentSchema, true));
            } else {
                this.schemas.put(uri, new Schema(uri, baseNode, null, true));
            }
            List refs = baseNode.findValues("$ref");
            for (JsonNode ref : refs) {
                if (!ref.isValueNode()) continue;
                String refVal = ref.asText();
                URI refURI = null;
                try {
                    refURI = URI.create(refVal);
                }
                catch (Exception e) {
                    LOGGER.info("Exception: {}", (Object)e.getMessage());
                }
                if (refURI == null || this.getByUri(refURI).isPresent()) continue;
                if (refURI.isAbsolute()) {
                    this.create(refURI);
                    continue;
                }
                this.create(baseURI.resolve(refURI));
            }
        }
        return this.schemas.get(uri);
    }

    @Override
    public Schema create(Schema parent, String path) {
        URI id;
        if (path.equals("#")) {
            return parent;
        }
        path = StringUtils.stripEnd((String)path, (String)"#?&/");
        URI uRI = id = parent != null && parent.getId() != null ? parent.getId().resolve(path) : URI.create(path);
        if (this.selfReferenceWithoutParentFile(parent, path)) {
            this.schemas.put(id, new Schema(id, this.fragmentResolver.resolve(parent.getParentContent(), path), parent, false));
            return this.schemas.get(id);
        }
        return this.create(id);
    }

    protected boolean selfReferenceWithoutParentFile(Schema parent, String path) {
        return parent != null && (parent.getId() == null || parent.getId().toString().startsWith("#/")) && path.startsWith("#/");
    }

    @Override
    public synchronized void clearCache() {
        this.schemas.clear();
    }

    @Override
    public Integer getSize() {
        return this.schemas.size();
    }

    @Override
    public Optional<Schema> getById(URI id) {
        for (Schema schema : this.schemas.values()) {
            if (schema.getId() == null || !schema.getId().equals(id)) continue;
            return Optional.of((Object)schema);
        }
        return Optional.absent();
    }

    @Override
    public Optional<Schema> getByUri(URI uri) {
        for (Schema schema : this.schemas.values()) {
            if (!schema.getURI().equals(uri)) continue;
            return Optional.of((Object)schema);
        }
        return Optional.absent();
    }

    @Override
    public Integer getFileUriCount() {
        int count = 0;
        for (Schema schema : this.schemas.values()) {
            if (!schema.getURI().getScheme().equals("file")) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Integer getHttpUriCount() {
        int count = 0;
        for (Schema schema : this.schemas.values()) {
            if (!schema.getURI().getScheme().equals("http")) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Schema> getSchemaIterator() {
        ArrayList schemaList = Lists.newArrayList(this.schemas.values());
        Collections.sort(schemaList, this);
        return schemaList.iterator();
    }

    @Override
    public ObjectNode resolveProperties(Schema schema, ObjectNode fieldNode, String resourceId) {
        ObjectNode schemaProperties = NODE_FACTORY.objectNode();
        ObjectNode parentProperties = NODE_FACTORY.objectNode();
        if (fieldNode == null) {
            ObjectNode schemaContent = (ObjectNode)schema.getContent();
            if (schemaContent.has("properties")) {
                ObjectNode parentContent;
                schemaProperties = (ObjectNode)schemaContent.get("properties");
                if (schema.getParentContent() != null && (parentContent = (ObjectNode)schema.getParentContent()).has("properties")) {
                    parentProperties = (ObjectNode)parentContent.get("properties");
                }
            }
        } else if (fieldNode != null && fieldNode.size() > 0) {
            if (fieldNode.has("properties") && fieldNode.get("properties").isObject() && fieldNode.get("properties").size() > 0) {
                schemaProperties = (ObjectNode)fieldNode.get("properties");
            }
            URI parentURI = null;
            if (fieldNode.has("$ref") || fieldNode.has("extends")) {
                URI absoluteURI;
                JsonNode refNode = fieldNode.get("$ref");
                JsonNode extendsNode = fieldNode.get("extends");
                if (refNode != null && refNode.isValueNode()) {
                    parentURI = URI.create(refNode.asText());
                } else if (extendsNode != null && extendsNode.isObject()) {
                    parentURI = URI.create(extendsNode.get("$ref").asText());
                }
                ObjectNode parentContent = null;
                if (parentURI.isAbsolute()) {
                    absoluteURI = parentURI;
                } else {
                    absoluteURI = schema.getURI().resolve(parentURI);
                    if (!absoluteURI.isAbsolute() || absoluteURI.isAbsolute() && !this.getByUri(absoluteURI).isPresent()) {
                        absoluteURI = schema.getParentURI().resolve(parentURI);
                    }
                }
                if (absoluteURI != null && absoluteURI.isAbsolute()) {
                    if (this.getByUri(absoluteURI).isPresent()) {
                        parentContent = (ObjectNode)((Schema)this.getByUri(absoluteURI).get()).getContent();
                    }
                    if (parentContent != null && parentContent.isObject() && parentContent.has("properties")) {
                        parentProperties = (ObjectNode)parentContent.get("properties");
                    } else if (absoluteURI.getPath().endsWith("#properties")) {
                        absoluteURI = URI.create(absoluteURI.toString().replace("#properties", ""));
                        parentProperties = (ObjectNode)((Schema)this.getByUri(absoluteURI).get()).getContent().get("properties");
                    }
                }
            }
        }
        ObjectNode resolvedProperties = NODE_FACTORY.objectNode();
        resolvedProperties = parentProperties != null && parentProperties.size() > 0 ? SchemaUtil.mergeProperties(schemaProperties, parentProperties) : schemaProperties.deepCopy();
        return resolvedProperties;
    }

    @Override
    public ObjectNode resolveItems(Schema schema, ObjectNode fieldNode, String resourceId) {
        ObjectNode schemaItems = NODE_FACTORY.objectNode();
        ObjectNode parentItems = NODE_FACTORY.objectNode();
        if (fieldNode == null) {
            ObjectNode schemaContent = (ObjectNode)schema.getContent();
            if (schemaContent.has("items")) {
                ObjectNode parentContent;
                schemaItems = (ObjectNode)schemaContent.get("items");
                if (schema.getParentContent() != null && (parentContent = (ObjectNode)schema.getParentContent()).has("items")) {
                    parentItems = (ObjectNode)parentContent.get("items");
                }
            }
        } else if (fieldNode != null && fieldNode.size() > 0) {
            if (fieldNode.has("items") && fieldNode.get("items").isObject() && fieldNode.get("items").size() > 0) {
                schemaItems = (ObjectNode)fieldNode.get("items");
            }
            URI parentURI = null;
            if (fieldNode.has("$ref") || fieldNode.has("extends")) {
                URI absoluteURI;
                JsonNode refNode = fieldNode.get("$ref");
                JsonNode extendsNode = fieldNode.get("extends");
                if (refNode != null && refNode.isValueNode()) {
                    parentURI = URI.create(refNode.asText());
                } else if (extendsNode != null && extendsNode.isObject()) {
                    parentURI = URI.create(extendsNode.get("$ref").asText());
                }
                ObjectNode parentContent = null;
                if (parentURI.isAbsolute()) {
                    absoluteURI = parentURI;
                } else {
                    absoluteURI = schema.getURI().resolve(parentURI);
                    if (!absoluteURI.isAbsolute() || absoluteURI.isAbsolute() && !this.getByUri(absoluteURI).isPresent()) {
                        absoluteURI = schema.getParentURI().resolve(parentURI);
                    }
                }
                if (absoluteURI != null && absoluteURI.isAbsolute()) {
                    if (this.getByUri(absoluteURI).isPresent()) {
                        parentContent = (ObjectNode)((Schema)this.getByUri(absoluteURI).get()).getContent();
                    }
                    if (parentContent != null && parentContent.isObject() && parentContent.has("items")) {
                        parentItems = (ObjectNode)parentContent.get("items");
                    } else if (absoluteURI.getPath().endsWith("#items")) {
                        absoluteURI = URI.create(absoluteURI.toString().replace("#items", ""));
                        parentItems = (ObjectNode)((Schema)this.getByUri(absoluteURI).get()).getContent().get("items");
                    }
                }
            }
        }
        ObjectNode resolvedItems = NODE_FACTORY.objectNode();
        resolvedItems = parentItems != null && parentItems.size() > 0 ? SchemaUtil.mergeProperties(schemaItems, parentItems) : schemaItems.deepCopy();
        return resolvedItems;
    }

    @Override
    public int compare(Schema left, Schema right) {
        Optional<URI> resolvedURI;
        String connectorRefText;
        Optional<Schema> possibleConnector;
        Optional<URI> possibleConnectorURI;
        Optional<URI> resolvedURI2;
        String refText;
        if (left.equals(right)) {
            return 0;
        }
        Schema candidateAncestor = left;
        while (candidateAncestor.getParent() != null) {
            if (!(candidateAncestor = candidateAncestor.getParent()).equals(right)) continue;
            return 1;
        }
        candidateAncestor = right;
        while (candidateAncestor.getParent() != null) {
            if (!(candidateAncestor = candidateAncestor.getParent()).equals(left)) continue;
            return -1;
        }
        for (JsonNode refNode : left.getContent().findValues("$ref")) {
            refText = refNode.asText();
            resolvedURI2 = URIUtil.safeResolve(left.getURI(), refText);
            if (!resolvedURI2.isPresent() || !((URI)resolvedURI2.get()).equals(right.getURI())) continue;
            return 1;
        }
        for (JsonNode refNode : right.getContent().findValues("$ref")) {
            refText = refNode.asText();
            resolvedURI2 = URIUtil.safeResolve(right.getURI(), refText);
            if (!resolvedURI2.isPresent() || !((URI)resolvedURI2.get()).equals(left.getURI())) continue;
            return -1;
        }
        for (JsonNode refNode : left.getContent().findValues("$ref")) {
            refText = refNode.asText();
            possibleConnectorURI = URIUtil.safeResolve(left.getURI(), refText);
            if (!possibleConnectorURI.isPresent() || !(possibleConnector = this.getByUri((URI)possibleConnectorURI.get())).isPresent()) continue;
            for (JsonNode connectorRefNode : ((Schema)possibleConnector.get()).getContent().findValues("$ref")) {
                connectorRefText = connectorRefNode.asText();
                resolvedURI = URIUtil.safeResolve(((Schema)possibleConnector.get()).getURI(), connectorRefText);
                if (!resolvedURI.isPresent() || !((URI)resolvedURI.get()).equals(right.getURI())) continue;
                return 1;
            }
        }
        for (JsonNode refNode : right.getContent().findValues("$ref")) {
            refText = refNode.asText();
            possibleConnectorURI = URIUtil.safeResolve(right.getURI(), refText);
            if (!possibleConnectorURI.isPresent() || !(possibleConnector = this.getByUri((URI)possibleConnectorURI.get())).isPresent()) continue;
            for (JsonNode connectorRefNode : ((Schema)possibleConnector.get()).getContent().findValues("$ref")) {
                connectorRefText = connectorRefNode.asText();
                resolvedURI = URIUtil.safeResolve(((Schema)possibleConnector.get()).getURI(), connectorRefText);
                if (!resolvedURI.isPresent() || !((URI)resolvedURI.get()).equals(left.getURI())) continue;
                return -1;
            }
        }
        return 0;
    }
}

