/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util.schema;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;

public class Schema {
    private final URI id;
    private final URI uri;
    private final JsonNode content;
    private final Schema parent;
    private final boolean generate;

    public Schema(URI uri, JsonNode content, Schema parent, boolean generate) {
        this.uri = uri;
        this.content = content;
        this.parent = parent;
        this.generate = generate;
        this.id = content.has("id") ? URI.create(content.get("id").asText()) : null;
    }

    public URI getId() {
        return this.id;
    }

    public URI getURI() {
        return this.uri;
    }

    public JsonNode getContent() {
        return this.content;
    }

    public JsonNode getParentContent() {
        if (this.parent != null) {
            return this.parent.getContent();
        }
        return null;
    }

    public URI getParentURI() {
        if (this.parent != null) {
            return this.parent.getURI();
        }
        return null;
    }

    public boolean isGenerated() {
        return this.generate;
    }

    public Schema getParent() {
        return this.parent;
    }
}

