/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util.schema;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import org.apache.streams.util.schema.GenerationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    public static String dropSourcePathPrefix(String inputFile, String sourceDirectory) {
        if (Strings.isNullOrEmpty((String)sourceDirectory)) {
            return inputFile;
        }
        try {
            if (!inputFile.contains(sourceDirectory)) break block5;
            if (inputFile.indexOf(sourceDirectory) > 0) {
                return inputFile.substring(inputFile.indexOf(sourceDirectory) + sourceDirectory.length() + 1);
            }
        }
        finally {
            return inputFile;
        }
        {
            block5: {
            }
        }
    }

    public static String swapExtension(String inputFile, String originalExtension, String newExtension) {
        if (inputFile.endsWith("." + originalExtension)) {
            return inputFile.replace("." + originalExtension, "." + newExtension);
        }
        return inputFile;
    }

    public static String dropExtension(String inputFile) {
        if (inputFile.contains(".")) {
            return inputFile.substring(0, inputFile.lastIndexOf("."));
        }
        return inputFile;
    }

    public static void writeFile(String resourceFile, String resourceContent) {
        try {
            File path = new File(resourceFile);
            File dir = path.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Files.write(Paths.get(resourceFile, new String[0]), resourceContent.getBytes(), StandardOpenOption.CREATE_NEW);
        }
        catch (Exception e) {
            LOGGER.error("Write Exception: {}", (Throwable)e);
        }
    }

    public static void resolveRecursive(GenerationConfig config, List<File> schemaFiles) {
        Preconditions.checkArgument((schemaFiles.size() > 0 ? 1 : 0) != 0);
        int i = 0;
        while (schemaFiles.size() > i) {
            File child = schemaFiles.get(i);
            if (child.isDirectory()) {
                schemaFiles.addAll(Arrays.asList(child.listFiles(config.getFileFilter())));
                schemaFiles.remove(child);
                continue;
            }
            ++i;
        }
    }
}

