/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util.oauth.tokens.tokenmanager.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.streams.util.oauth.tokens.tokenmanager.SimpleTokenManager;

public class BasicTokenManger<T>
implements SimpleTokenManager<T> {
    private ArrayList<T> availableTokens;
    private int nextToken;

    public BasicTokenManger() {
        this(null);
    }

    public BasicTokenManger(Collection<T> tokens) {
        if (tokens != null) {
            this.availableTokens = new ArrayList(tokens.size());
            this.addAllTokensToPool(tokens);
        } else {
            this.availableTokens = new ArrayList();
        }
        this.nextToken = 0;
    }

    @Override
    public synchronized boolean addTokenToPool(T token) {
        if (token == null || this.availableTokens.contains(token)) {
            return false;
        }
        return this.availableTokens.add(token);
    }

    @Override
    public synchronized boolean addAllTokensToPool(Collection<T> tokens) {
        int startSize = this.availableTokens.size();
        for (T token : tokens) {
            this.addTokenToPool(token);
        }
        return startSize < this.availableTokens.size();
    }

    @Override
    public synchronized T getNextAvailableToken() {
        T token = null;
        if (this.availableTokens.size() == 0) {
            return token;
        }
        token = this.availableTokens.get(this.nextToken++);
        if (this.nextToken == this.availableTokens.size()) {
            this.nextToken = 0;
        }
        return token;
    }

    @Override
    public synchronized int numAvailableTokens() {
        return this.availableTokens.size();
    }
}

