/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util.api.requests.backoff;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.streams.util.api.requests.backoff.BackOffException;
import org.apache.streams.util.api.requests.backoff.BackOffStrategy;

public abstract class AbstractBackOffStrategy
implements BackOffStrategy {
    private long baseSleepTime;
    private long lastSleepTime;
    private int maxAttempts;
    private AtomicInteger attemptsCount;

    public AbstractBackOffStrategy(long baseBackOffTime) {
        this(baseBackOffTime, -1);
    }

    public AbstractBackOffStrategy(long baseBackOffTime, int maximumNumberOfBackOffAttempts) {
        if (baseBackOffTime <= 0L) {
            throw new IllegalArgumentException("backOffTimeInMilliSeconds is not greater than 0 : " + baseBackOffTime);
        }
        if (maximumNumberOfBackOffAttempts <= 0 && maximumNumberOfBackOffAttempts != -1) {
            throw new IllegalArgumentException("maximumNumberOfBackOffAttempts is not greater than 0 : " + maximumNumberOfBackOffAttempts);
        }
        this.baseSleepTime = baseBackOffTime;
        this.maxAttempts = maximumNumberOfBackOffAttempts;
        this.attemptsCount = new AtomicInteger(0);
    }

    @Override
    public void backOff() throws BackOffException {
        int attempt = this.attemptsCount.getAndIncrement();
        if (attempt >= this.maxAttempts && this.maxAttempts != -1) {
            throw new BackOffException(attempt, this.lastSleepTime);
        }
        try {
            this.lastSleepTime = this.calculateBackOffTime(attempt, this.baseSleepTime);
            Thread.sleep(this.lastSleepTime);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void reset() {
        this.attemptsCount.set(0);
    }

    protected abstract long calculateBackOffTime(int var1, long var2);
}

