/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;

public class SerializationUtil {
    public static byte[] serialize(Object obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Object deserialize(byte[] serialized) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(classLoader, (InputStream)bis);
            Object ret = ois.readObject();
            ois.close();
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T cloneBySerialization(T obj) {
        if (obj != null) {
            return (T)SerializationUtil.deserialize(SerializationUtil.serialize(obj));
        }
        return null;
    }
}

