/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;

public class GuidUtils {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static String generateGuid(String ... parts) {
        StringBuilder seed = new StringBuilder();
        for (String part : parts) {
            Preconditions.checkNotNull((Object)part);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)part) ? 1 : 0) != 0);
            seed.append(part);
        }
        String hash = Hashing.goodFastHash((int)24).hashString((CharSequence)seed, UTF8_CHARSET).asBytes().toString();
        return hash;
    }
}

