/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtil {
    private static final String REGEX_ONLY_NUMBERS = "[0-9]+";
    private static final Map<String, String> DATE_FORMAT_REGEXPS = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("^\\d{8}$", "yyyyMMdd");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}$", "dd-MM-yyyy");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}$", "yyyy-MM-dd");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}$", "MM/dd/yyyy");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}$", "yyyy/MM/dd");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$", "dd MMM yyyy");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$", "dd MMMM yyyy");
            this.put("^\\d{12}$", "yyyyMMddHHmm");
            this.put("^\\d{8}\\s\\d{4}$", "yyyyMMdd HHmm");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}$", "dd-MM-yyyy HH:mm");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy-MM-dd HH:mm");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}$", "MM/dd/yyyy HH:mm");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy/MM/dd HH:mm");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMM yyyy HH:mm");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMMM yyyy HH:mm");
            this.put("^\\d{14}$", "yyyyMMddHHmmss");
            this.put("^\\d{8}\\s\\d{6}$", "yyyyMMdd HHmmss");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd-MM-yyyy HH:mm:ss");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm:ss");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "MM/dd/yyyy HH:mm:ss");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy/MM/dd HH:mm:ss");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMM yyyy HH:mm:ss");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMMM yyyy HH:mm:ss");
        }
    };

    public static String determineDateFormat(String dateString) throws ParseException {
        for (String regexp : DATE_FORMAT_REGEXPS.keySet()) {
            if (!dateString.toLowerCase().matches(regexp)) continue;
            return DATE_FORMAT_REGEXPS.get(regexp);
        }
        throw new ParseException("unable to parse date", 0);
    }

    public static DateTime determineDate(String dateString) throws ParseException {
        if ((dateString = dateString.trim()).matches(REGEX_ONLY_NUMBERS)) {
            return new DateTime((Object)new Date(Long.parseLong(dateString)));
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateUtil.determineDateFormat(dateString));
            dateFormat.setLenient(false);
            return new DateTime((Object)dateFormat.parse(dateString));
        }
        catch (Exception exception) {
            return new DateTime((Object)DateTime.parse((String)dateString));
        }
    }

    public static DateTime determineDateTime(String dateString) throws ParseException {
        return new DateTime((Object)DateUtil.determineDate(dateString));
    }

    public static DateTime determineDateTime(String dateString, DateTimeZone theTimeZone) throws ParseException {
        DateTime beforeTimeZone = DateUtil.determineDateTime(dateString);
        return new DateTime(beforeTimeZone.getYear(), beforeTimeZone.getMonthOfYear(), beforeTimeZone.getDayOfMonth(), beforeTimeZone.getHourOfDay(), beforeTimeZone.getMinuteOfHour(), beforeTimeZone.getSecondOfMinute(), beforeTimeZone.getMillisOfSecond(), theTimeZone);
    }

    public static String getAliasForDate(String date, String prefix) throws ParseException {
        return DateUtil.getAliasesForDateRange(date, null, prefix).iterator().next();
    }

    public static String getAliasForDate(DateTime date, String prefix) throws ParseException {
        return DateUtil.getAliasesForDateRange(date, null, prefix).iterator().next();
    }

    public static Set<String> getAliasesForDateRange(String starDate, String endDate, String prefix) throws ParseException {
        DateTime start = null;
        DateTime end = null;
        DateTimeFormatter df = ISODateTimeFormat.dateTimeNoMillis();
        try {
            start = df.parseDateTime(starDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (start == null) {
            start = DateUtil.determineDateTime(starDate);
        }
        if (endDate != null) {
            try {
                end = df.parseDateTime(endDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (end == null) {
                end = DateUtil.determineDateTime(endDate);
            }
        }
        return DateUtil.getAliasesForDateRange(start, end, prefix);
    }

    public static Set<String> getAliasesForDateRange(DateTime startDate, DateTime endDate, String prefix) {
        HashSet<String> aliases = new HashSet<String>();
        aliases.add(prefix + "_" + DateUtil.getDateAbbreviation(startDate.getYear(), startDate.getMonthOfYear()));
        if (endDate == null) {
            return aliases;
        }
        while (endDate.isAfter((ReadableInstant)startDate)) {
            aliases.add(prefix + "_" + DateUtil.getDateAbbreviation(endDate.getYear(), endDate.getMonthOfYear()));
            endDate = endDate.minusMonths(1);
        }
        return aliases;
    }

    private static String getDateAbbreviation(int year, int month) {
        if (month > 9) {
            return Integer.toString(year) + Integer.toString(month);
        }
        return Integer.toString(year) + "0" + Integer.toString(month);
    }
}

