/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.util;

import java.lang.management.ManagementFactory;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentUtils.class);

    public static <T> void offerUntilSuccess(T entry, Queue<T> queue) {
        boolean success;
        do {
            success = queue.offer(entry);
            Thread.yield();
        } while (!success);
    }

    public static <T> T pollWhileNotEmpty(Queue<T> queue) {
        T item = queue.poll();
        while (!queue.isEmpty() && item == null) {
            Thread.yield();
            item = queue.poll();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String pollUntilStringNotEmpty(Queue queue) {
        String result = null;
        do {
            Class<ComponentUtils> clazz = ComponentUtils.class;
            // MONITORENTER : org.apache.streams.util.ComponentUtils.class
            try {
                result = (String)queue.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.yield();
            if (result != null) return result;
        } while (!StringUtils.isNotEmpty((CharSequence)result));
        return result;
    }

    public static void shutdownExecutor(ExecutorService stream, int initialWait, int secondaryWait) {
        stream.shutdown();
        try {
            if (!stream.awaitTermination(initialWait, TimeUnit.SECONDS)) {
                stream.shutdownNow();
                if (!stream.awaitTermination(secondaryWait, TimeUnit.SECONDS)) {
                    LOGGER.error("Executor Service did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            stream.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static void removeAllMBeansOfDomain(String domain) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        domain = domain.endsWith(":") ? domain : domain + ":";
        ObjectName objectName = new ObjectName(domain + "*");
        Set<ObjectName> mbeanNames = mbs.queryNames(objectName, null);
        for (ObjectName name : mbeanNames) {
            mbs.unregisterMBean(name);
        }
    }

    public static <V> void registerLocalMBean(String name, V mbean) {
        try {
            ObjectName objectName = new ObjectName(name);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(mbean, objectName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            LOGGER.error("Failed to register MXBean : {}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

