/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.twitter.pojo.Tweet;
import org.apache.streams.twitter.provider.TwitterErrorHandler;
import org.apache.streams.twitter.provider.TwitterTimelineProvider;
import org.apache.streams.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Paging;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;

public class TwitterTimelineProviderTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwitterTimelineProviderTask.class);
    private static ObjectMapper MAPPER = new StreamsJacksonMapper((List)Lists.newArrayList((Object[])new String[]{"EEE MMM dd HH:mm:ss Z yyyy"}));
    protected TwitterTimelineProvider provider;
    protected Twitter client;
    protected Long id;

    public TwitterTimelineProviderTask(TwitterTimelineProvider provider, Twitter twitter, Long id) {
        this.provider = provider;
        this.client = twitter;
        this.id = id;
    }

    @Override
    public void run() {
        Paging paging = new Paging(1, 200);
        ResponseList statuses = null;
        int count = 0;
        LOGGER.info(this.id + " Thread Starting");
        do {
            int keepTrying = 0;
            while (keepTrying < 5) {
                try {
                    this.client = this.provider.getTwitterClient();
                    statuses = this.client.getUserTimeline(this.id.longValue(), paging);
                    for (Status tStat : statuses) {
                        String json = TwitterObjectFactory.getRawJSON((Object)tStat);
                        if ((long)count >= this.provider.getConfig().getMaxItems()) continue;
                        try {
                            Tweet tweet = (Tweet)MAPPER.readValue(json, Tweet.class);
                            ComponentUtils.offerUntilSuccess((Object)new StreamsDatum((Object)tweet), this.provider.providerQueue);
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Failed to read document as Tweet ", (Object)tStat);
                        }
                        ++count;
                    }
                    paging.setPage(paging.getPage() + 1);
                    keepTrying = 10;
                }
                catch (TwitterException twitterException) {
                    keepTrying += TwitterErrorHandler.handleTwitterError(this.client, this.id, (Exception)((Object)twitterException));
                }
                catch (Exception e) {
                    keepTrying += TwitterErrorHandler.handleTwitterError(this.client, this.id, e);
                }
            }
        } while (this.provider.shouldContinuePulling((List<Status>)statuses) && (long)count < this.provider.getConfig().getMaxItems());
        LOGGER.info(this.id + " Thread Finished");
    }
}

