/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.Queue;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.twitter.pojo.Follow;
import org.apache.streams.twitter.provider.TwitterErrorHandler;
import org.apache.streams.twitter.provider.TwitterFollowingProvider;
import org.apache.streams.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.IDs;
import twitter4j.PagableResponseList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.User;

public class TwitterFollowingProviderTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwitterFollowingProviderTask.class);
    private static final ObjectMapper mapper = StreamsJacksonMapper.getInstance();
    protected TwitterFollowingProvider provider;
    protected Twitter client;
    protected Long id;
    protected String screenName;
    int count = 0;

    public TwitterFollowingProviderTask(TwitterFollowingProvider provider, Twitter twitter, Long id) {
        this.provider = provider;
        this.client = twitter;
        this.id = id;
    }

    public TwitterFollowingProviderTask(TwitterFollowingProvider provider, Twitter twitter, String screenName) {
        this.provider = provider;
        this.client = twitter;
        this.screenName = screenName;
    }

    @Override
    public void run() {
        Preconditions.checkArgument((this.id != null || this.screenName != null ? 1 : 0) != 0);
        if (this.id != null) {
            this.getFollowing(this.id);
        } else if (this.screenName != null) {
            this.getFollowing(this.screenName);
        }
        LOGGER.info(this.id != null ? this.id.toString() : this.screenName + " Thread Finished");
    }

    protected void getFollowing(Long id) {
        Preconditions.checkArgument((this.provider.getConfig().getEndpoint().equals("friends") || this.provider.getConfig().getEndpoint().equals("followers") ? 1 : 0) != 0);
        if (this.provider.getConfig().getIdsOnly().booleanValue()) {
            this.collectIds(id);
        } else {
            this.collectUsers(id);
        }
    }

    private void collectUsers(Long id) {
        int keepTrying = 0;
        long curser = -1L;
        do {
            try {
                String userJson;
                try {
                    User user = this.client.users().showUser(id.longValue());
                    userJson = TwitterObjectFactory.getRawJSON((Object)user);
                }
                catch (TwitterException e) {
                    LOGGER.error("Failure looking up " + id);
                    break;
                }
                PagableResponseList list = null;
                if (this.provider.getConfig().getEndpoint().equals("followers")) {
                    list = this.client.friendsFollowers().getFollowersList(id.longValue(), curser, this.provider.getConfig().getMaxItems().intValue());
                } else if (this.provider.getConfig().getEndpoint().equals("friends")) {
                    list = this.client.friendsFollowers().getFriendsList(id.longValue(), curser, this.provider.getConfig().getMaxItems().intValue());
                }
                Preconditions.checkNotNull(list);
                Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0);
                for (User other : list) {
                    String otherJson = TwitterObjectFactory.getRawJSON((Object)other);
                    try {
                        Follow follow = null;
                        if (this.provider.getConfig().getEndpoint().equals("followers")) {
                            follow = new Follow().withFollowee((org.apache.streams.twitter.pojo.User)mapper.readValue(userJson, org.apache.streams.twitter.pojo.User.class)).withFollower((org.apache.streams.twitter.pojo.User)mapper.readValue(otherJson, org.apache.streams.twitter.pojo.User.class));
                        } else if (this.provider.getConfig().getEndpoint().equals("friends")) {
                            follow = new Follow().withFollowee((org.apache.streams.twitter.pojo.User)mapper.readValue(otherJson, org.apache.streams.twitter.pojo.User.class)).withFollower((org.apache.streams.twitter.pojo.User)mapper.readValue(userJson, org.apache.streams.twitter.pojo.User.class));
                        }
                        Preconditions.checkNotNull(follow);
                        if ((long)this.count >= this.provider.getConfig().getMaxItems()) continue;
                        ComponentUtils.offerUntilSuccess((Object)new StreamsDatum((Object)follow), (Queue)this.provider.providerQueue);
                        ++this.count;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Exception: {}", (Throwable)e);
                    }
                }
                if (!list.hasNext() || list.getNextCursor() == 0L) break;
                curser = list.getNextCursor();
            }
            catch (TwitterException twitterException) {
                keepTrying += TwitterErrorHandler.handleTwitterError(this.client, (Exception)((Object)twitterException));
            }
            catch (Exception e) {
                keepTrying += TwitterErrorHandler.handleTwitterError(this.client, e);
            }
        } while (curser != 0L && (long)keepTrying < this.provider.getConfig().getRetryMax() && (long)this.count < this.provider.getConfig().getMaxItems());
    }

    private void collectIds(Long id) {
        int keepTrying = 0;
        long curser = -1L;
        do {
            try {
                IDs ids = null;
                if (this.provider.getConfig().getEndpoint().equals("followers")) {
                    ids = this.client.friendsFollowers().getFollowersIDs(id.longValue(), curser, this.provider.getConfig().getMaxItems().intValue());
                } else if (this.provider.getConfig().getEndpoint().equals("friends")) {
                    ids = this.client.friendsFollowers().getFriendsIDs(id.longValue(), curser, this.provider.getConfig().getMaxItems().intValue());
                }
                Preconditions.checkNotNull(ids);
                Preconditions.checkArgument((ids.getIDs().length > 0 ? 1 : 0) != 0);
                for (long otherId : ids.getIDs()) {
                    try {
                        Follow follow = null;
                        if (this.provider.getConfig().getEndpoint().equals("followers")) {
                            follow = new Follow().withFollowee(new org.apache.streams.twitter.pojo.User().withId(id)).withFollower(new org.apache.streams.twitter.pojo.User().withId(otherId));
                        } else if (this.provider.getConfig().getEndpoint().equals("friends")) {
                            follow = new Follow().withFollowee(new org.apache.streams.twitter.pojo.User().withId(otherId)).withFollower(new org.apache.streams.twitter.pojo.User().withId(id));
                        }
                        Preconditions.checkNotNull(follow);
                        if ((long)this.count >= this.provider.getConfig().getMaxItems()) continue;
                        ComponentUtils.offerUntilSuccess((Object)new StreamsDatum((Object)follow), (Queue)this.provider.providerQueue);
                        ++this.count;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Exception: {}", (Throwable)e);
                    }
                }
                if (!ids.hasNext() || ids.getNextCursor() == 0L) break;
                curser = ids.getNextCursor();
            }
            catch (TwitterException twitterException) {
                keepTrying += TwitterErrorHandler.handleTwitterError(this.client, id, (Exception)((Object)twitterException));
            }
            catch (Exception e) {
                keepTrying += TwitterErrorHandler.handleTwitterError(this.client, e);
            }
        } while (curser != 0L && (long)keepTrying < this.provider.getConfig().getRetryMax() && (long)this.count < this.provider.getConfig().getMaxItems());
    }

    protected void getFollowing(String screenName) {
        User user = null;
        try {
            user = this.client.users().showUser(screenName);
        }
        catch (TwitterException e) {
            LOGGER.error("Failure looking up " + this.id);
        }
        Preconditions.checkNotNull((Object)user);
        this.getFollowing(user.getId());
    }
}

