/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.twitter.pojo.Delete;
import org.apache.streams.twitter.pojo.FriendList;
import org.apache.streams.twitter.pojo.Retweet;
import org.apache.streams.twitter.pojo.Tweet;
import org.apache.streams.twitter.pojo.User;
import org.apache.streams.twitter.pojo.UserstreamEvent;

public class TwitterEventClassifier
implements Serializable {
    private static ObjectMapper mapper = new StreamsJacksonMapper((List)Lists.newArrayList((Object[])new String[]{"EEE MMM dd HH:mm:ss Z yyyy"}));

    public static Class detectClass(String json) {
        ObjectNode objectNode;
        Preconditions.checkNotNull((Object)json);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)json));
        try {
            objectNode = (ObjectNode)mapper.readTree(json);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (objectNode.findValue("retweeted_status") != null && objectNode.get("retweeted_status") != null) {
            return Retweet.class;
        }
        if (objectNode.findValue("delete") != null) {
            return Delete.class;
        }
        if (objectNode.findValue("friends") != null || objectNode.findValue("friends_str") != null) {
            return FriendList.class;
        }
        if (objectNode.findValue("target_object") != null) {
            return UserstreamEvent.class;
        }
        if (objectNode.findValue("location") != null && objectNode.findValue("user") == null) {
            return User.class;
        }
        return Tweet.class;
    }
}

