/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.provider;

import org.apache.streams.config.ComponentConfigurator;
import org.apache.streams.config.StreamsConfigurator;
import org.apache.streams.twitter.TwitterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.RateLimitStatus;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class TwitterErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwitterErrorHandler.class);
    protected static long retry = ((TwitterConfiguration)new ComponentConfigurator(TwitterConfiguration.class).detectConfiguration(StreamsConfigurator.getConfig().getConfig("twitter"))).getRetrySleepMs();
    protected static long retryMax = ((TwitterConfiguration)new ComponentConfigurator(TwitterConfiguration.class).detectConfiguration(StreamsConfigurator.getConfig().getConfig("twitter"))).getRetryMax();

    @Deprecated
    public static int handleTwitterError(Twitter twitter, Exception exception) {
        return TwitterErrorHandler.handleTwitterError(twitter, null, exception);
    }

    public static int handleTwitterError(Twitter twitter, Long id, Exception exception) {
        if (exception instanceof TwitterException) {
            TwitterException e = (TwitterException)((Object)exception);
            if (e.exceededRateLimitation()) {
                long millisUntilReset = retry;
                RateLimitStatus rateLimitStatus = e.getRateLimitStatus();
                if (rateLimitStatus != null) {
                    millisUntilReset = rateLimitStatus.getSecondsUntilReset() * 1000;
                }
                LOGGER.warn("Rate Limit Exceeded. Will retry in {} seconds...", (Object)(millisUntilReset / 1000L));
                try {
                    Thread.sleep(millisUntilReset);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                return 1;
            }
            if (e.isCausedByNetworkIssue()) {
                LOGGER.info("Twitter Network Issues Detected. Backing off...");
                LOGGER.info("{} - {}", (Object)e.getExceptionCode(), (Object)e.getLocalizedMessage());
                try {
                    Thread.sleep(retry);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                return 1;
            }
            if (e.isErrorMessageAvailable()) {
                if (e.getMessage().toLowerCase().contains("does not exist")) {
                    if (id != null) {
                        LOGGER.warn("User does not exist: {}", (Object)id);
                    } else {
                        LOGGER.warn("User does not exist");
                    }
                    return (int)retryMax;
                }
                return (int)retryMax / 3;
            }
            if (e.getExceptionCode().equals("ced778ef-0c669ac0")) {
                return (int)retryMax / 3;
            }
            if (e.getExceptionCode().equals("4be80492-0a7bf7c7")) {
                if (id != null) {
                    LOGGER.warn("Authentication Exception accessing id: {}", (Object)id);
                } else {
                    LOGGER.warn("Authentication Exception");
                }
                return (int)retryMax;
            }
            LOGGER.warn("Unknown Twitter Exception...");
            LOGGER.warn("  Account: {}", (Object)twitter);
            LOGGER.warn("   Access: {}", (Object)e.getAccessLevel());
            LOGGER.warn("     Code: {}", (Object)e.getExceptionCode());
            LOGGER.warn("  Message: {}", (Object)e.getLocalizedMessage());
            return (int)retryMax / 10;
        }
        if (exception instanceof RuntimeException) {
            LOGGER.warn("TwitterGrabber: Unknown Runtime Error", (Object)exception.getMessage());
            return (int)retryMax / 3;
        }
        LOGGER.info("Completely Unknown Exception: {}", (Throwable)exception);
        return (int)retryMax / 3;
    }
}

