/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.processor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.streams.components.http.HttpProcessorConfiguration;
import org.apache.streams.components.http.processor.SimpleHTTPGetProcessor;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsProcessor;
import org.apache.streams.pojo.json.Activity;

public class TwitterUrlApiProcessor
extends SimpleHTTPGetProcessor
implements StreamsProcessor {
    private static final String STREAMS_ID = "TwitterUrlApiProcessor";

    public TwitterUrlApiProcessor() {
        this.configuration.setHostname("urls.api.twitter.com");
        this.configuration.setResourcePath("/1/urls/count.json");
        this.configuration.setEntity(HttpProcessorConfiguration.Entity.ACTIVITY);
        this.configuration.setExtension("twitter_url_count");
    }

    public TwitterUrlApiProcessor(HttpProcessorConfiguration processorConfiguration) {
        super(processorConfiguration);
        this.configuration.setHostname("urls.api.twitter.com");
        this.configuration.setResourcePath("/1/urls/count.json");
        this.configuration.setEntity(HttpProcessorConfiguration.Entity.ACTIVITY);
        this.configuration.setExtension("twitter_url_count");
    }

    public String getId() {
        return STREAMS_ID;
    }

    public List<StreamsDatum> process(StreamsDatum entry) {
        Preconditions.checkArgument((boolean)(entry.getDocument() instanceof Activity));
        Activity activity = (Activity)this.mapper.convertValue(entry.getDocument(), Activity.class);
        if (activity.getLinks() != null && activity.getLinks().size() > 0) {
            return super.process(entry);
        }
        return Lists.newArrayList((Object[])new StreamsDatum[]{entry});
    }

    protected Map<String, String> prepareParams(StreamsDatum entry) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("url", (String)((Activity)this.mapper.convertValue(entry.getDocument(), Activity.class)).getLinks().get(0));
        return params;
    }
}

