/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsProcessor;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.twitter.pojo.Retweet;
import org.apache.streams.twitter.pojo.Tweet;
import org.apache.streams.twitter.pojo.User;
import org.apache.streams.twitter.provider.TwitterEventClassifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterProfileProcessor
implements StreamsProcessor,
Runnable {
    private static final String STREAMS_ID = "TwitterProfileProcessor";
    private static final Logger LOGGER = LoggerFactory.getLogger(TwitterProfileProcessor.class);
    private ObjectMapper mapper = StreamsJacksonMapper.getInstance((String)"EEE MMM dd HH:mm:ss Z yyyy");
    private Queue<StreamsDatum> inQueue;
    private Queue<StreamsDatum> outQueue;
    private static final String TERMINATE = "TERMINATE";

    @Override
    public void run() {
        block2: while (true) {
            try {
                block3: while (true) {
                    StreamsDatum item;
                    if ((item = this.inQueue.poll()).getDocument() instanceof String && item.equals((Object)TERMINATE)) {
                        LOGGER.info("Terminating!");
                        break block2;
                    }
                    Thread.sleep(new Random().nextInt(100));
                    Iterator<StreamsDatum> iterator = this.process(item).iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        StreamsDatum entry = iterator.next();
                        this.outQueue.offer(entry);
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public StreamsDatum createStreamsDatum(User user) {
        return new StreamsDatum((Object)user, user.getIdStr());
    }

    public String getId() {
        return STREAMS_ID;
    }

    public List<StreamsDatum> process(StreamsDatum entry) {
        ArrayList<StreamsDatum> result = new ArrayList<StreamsDatum>();
        try {
            String item = entry.getDocument() instanceof String ? (String)entry.getDocument() : this.mapper.writeValueAsString(entry.getDocument());
            Class inClass = TwitterEventClassifier.detectClass(item);
            if (inClass.equals(Tweet.class)) {
                LOGGER.debug("TWEET");
                Tweet tweet = (Tweet)this.mapper.readValue(item, Tweet.class);
                User user = tweet.getUser();
                result.add(this.createStreamsDatum(user));
            } else if (inClass.equals(Retweet.class)) {
                LOGGER.debug("RETWEET");
                Retweet retweet = (Retweet)this.mapper.readValue(item, Retweet.class);
                User user = retweet.getRetweetedStatus().getUser();
                result.add(this.createStreamsDatum(user));
            } else if (inClass.equals(User.class)) {
                LOGGER.debug("USER");
                User user = (User)this.mapper.readValue(item, User.class);
                result.add(this.createStreamsDatum(user));
            } else {
                return new ArrayList<StreamsDatum>();
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warn("Error processing " + entry.toString());
            return new ArrayList<StreamsDatum>();
        }
    }

    public void prepare(Object o) {
    }

    public void cleanUp() {
    }
}

